package com.geoway.jckj.biz.service.sys;

import com.baomidou.mybatisplus.extension.service.IService;
import com.geoway.jckj.biz.dto.RoleSystemsDTO;
import com.geoway.jckj.biz.entity.SysRole;
import com.geoway.jckj.biz.entity.SysRoleSystem;
import com.geoway.jckj.biz.entity.SysSystem;

import java.util.List;

/**
* @author daidongdong
* @description 针对表【sys_role_system的数据库操作Service
* @createDate 2024-10-15 17:25:14
*/
public interface SysRoleSystemService extends IService<SysRoleSystem> {


    /**
     * 保存角色关联的系统
     * @param roleId
     * @param systemIds
     * @param isClear
     */
    void saveRoleSystems(String roleId, List<String> systemIds,  boolean isClear);


    /**
     * 查询角色关联的系统
     * @param roleId
     * @return
     */
    List<SysSystem> queryRoleSystems(String roleId);

    /**
     * 查询角色关联的系统和应用
     * @param roleId
     * @return
     */
    RoleSystemsDTO queryRoleSystemDTOs(String roleId);

    /**
     * 删除角色关联的系统和应用列表
     * @param roleId
     * @param systemIds
     */
    void removeRoleSystem(String roleId, List<String> systemIds);

    /**
     * 移除角色关联的系统和应用
     * @param roleId
     * @param systemId
     */
    void removeRoleSystem(String roleId, String systemId);

    /**
     * 保存系统关联的角色
     * @param systemId
     * @param roleIds
     */
    void saveSystemRoles(String systemId, String roleIds);

    /**
     * 查询系统关联的角色
     * @param systemId
     * @return
     */
    List<SysRole> systemRelateRoles(String systemId);
}
