package com.geoway.jckj.biz.service.sys;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.jckj.biz.entity.*;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.ArrayList;
import java.util.List;

/**
* @author wangqiang
* @description 针对表【sys_user_tenant(用户租户关联表)】的数据库操作Service
* @createDate 2025-01-02 09:40:39
*/
public interface SysUserTenantService extends IService<SysUserTenant> {

    /**
     *  添加租户管理员
     * @param userIds
     * @param tenantId
     * @param isAdmin
     */
    void bindUsers(String userIds, String tenantId, Integer isAdmin);
    /**
     * 删除租户管理人员
     * @param tenantId
     * @param userIds
     */
    void removeBindUsers(String tenantId, String userIds);

    /**
     * 查找所有的租户管理员
     * @param tenantId
     * @return
     */
    List<SysUser> queryBindUsers(String tenantId);

    /**
     * 根据过滤条件查询分页
     * @param filterParam
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    IPage<SysUser> queryPageUsers(String filterParam, String tenantId, int page, int size);


}
