package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.jckj.biz.enums.SystemTypeEnum;
import com.geoway.jckj.biz.enums.TenantSpaceStatusEnum;
import com.geoway.jckj.biz.entity.*;
import com.geoway.jckj.biz.mapper.*;
import com.geoway.jckj.biz.service.sys.*;
import com.geoway.sso.client.constant.SsoConstant;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import com.geoway.sso.client.util.HttpUtils;
import com.github.yulichang.base.MPJBaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author 连世忠
 * @ClassName SysTenantSystemIsolateServiceImpl
 * @Description TODO
 * @date 2025/5/14 8:36
 * @Version 1.0
 */
@Service
public class SysTenantSpaceServiceImpl extends MPJBaseServiceImpl<SysTenantSpaceMapper, SysTenantSpace> implements SysTenantSpaceService {

    @Autowired
    private SysTenantMenuService sysTenantMenuService;
    @Autowired
    private SysMenuMapper sysMenuMapper;
    @Autowired
    private SysMenuPathMapper sysMenuPathMapper;
    @Autowired
    private SysSystemMapper sysSystemMapper;
    @Autowired
    private SysTenantMapper sysTenantMapper;
    @Autowired
    private  SysTenantSystemMapper sysTenantSystemMapper;

    private final static String TENANT_SPACE_CREATE_URL="/tenant/createSpace";

    @Override
    public TenantSpaceStatusEnum checkSpaceStatus(String tenantId, String systemId) {
        List<SysSystem> sysSystems= getRelRegisterSystems(tenantId,systemId);
        if(sysSystems.size()==0){
            return TenantSpaceStatusEnum.None;
        }
        LambdaQueryWrapper<SysTenantSpace> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysTenantSpace::getTenantid, tenantId);
        wrapper.eq(SysTenantSpace::getSpaceStatus,1);
        List<SysTenantSpace> sysTenantSpaces =this.list(wrapper);
        List<String> solateIds= sysTenantSpaces.stream().map(f->f.getSystemid()).collect(Collectors.toList());
        if(sysSystems.stream().anyMatch(f->!solateIds.contains(f.getId()))){
            return TenantSpaceStatusEnum.notCreated;
        }
        return TenantSpaceStatusEnum.created;
    }

    @Override
    public boolean createTenantSpace(String tenantId, String systemId) {
        List<String> systemIds=null;
        if(StrUtil.isBlank(systemId)){
            LambdaQueryWrapper<SysTenantSystem> wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysTenantSystem::getTenantid, tenantId);
            systemIds=sysTenantSystemMapper.selectList(wrapper).stream().map(f->f.getSystemid()).collect(Collectors.toList());
        }else{
            systemIds= Arrays.asList(systemId.split(","));
        }
        systemIds.forEach(f->createTenantSpaceOne(tenantId,f));
        return true;
    }


     private boolean createTenantSpaceOne(String tenantId, String systemId){
         List<SysSystem> sysSystems= getRelRegisterSystems(tenantId,systemId);
         if(sysSystems.size()==0){
             return true;
         }

         SysSystem noSystem=sysSystems.stream().filter(f-> StrUtil.isBlank(f.getBackendUrl())).findFirst().orElse(null);
         if(noSystem!=null){
             throw new RuntimeException(String.format("【%s】系统未配置后端地址，请核查",noSystem.getName()));
         }
         SysTenant sysTenant= sysTenantMapper.selectById(tenantId);
         Map<String,String> paramMap=new HashMap<>();
         paramMap.put("tenantKey",sysTenant.getKey());
         Map<String,String> header=new HashMap<>();
         Map<String,String> cacheUrls=new HashMap<>();
         header.put(SsoConstant.HEADER_ACCESS_TOKEN, CommonLoginUserUtil.getToken());
         for(SysSystem system:sysSystems){
             LambdaQueryWrapper<SysTenantSpace> wrapper = Wrappers.lambdaQuery();
             wrapper.eq(SysTenantSpace::getTenantid, tenantId);
             wrapper.eq(SysTenantSpace::getSystemid,system.getId());
             SysTenantSpace sysTenantSpace=this.getOne(wrapper);
             if(sysTenantSpace!=null){
                 continue;
             }
             if(!cacheUrls.containsKey(system.getBackendUrl())){
                 try {
                     String url = system.getBackendUrl() + TENANT_SPACE_CREATE_URL;
                     Result<Void> result = HttpUtils.postHttp(url, paramMap, header, null);
                     if (result == null) {
                         throw new RuntimeException(String.format("【%s】系统创建租户空间失败，请核查", system.getName()));
                     }
                     if (!result.isSuccess()) {
                         throw new RuntimeException(String.format("【%s】系统创建租户空间失败:%s，请核查", system.getName(), result.getMessage()));
                     }
                     cacheUrls.put(system.getBackendUrl(),system.getBackendUrl());
                 }catch (Exception exception){
                     throw new RuntimeException(exception);
                 }
             }
             sysTenantSpace=new SysTenantSpace();
             sysTenantSpace.setSpaceStatus(TenantSpaceStatusEnum.created.getValue());
             sysTenantSpace.setSystemid(system.getId());
             sysTenantSpace.setTenantid(tenantId);
             this.save(sysTenantSpace);

         }
         return true;
     }
    /**
     * 所有需要资源隔离的应用系统，注意是注册的应用系统，不是构建的
     * @param tenantId
     * @return
     */
    private List<SysSystem> getRelRegisterSystems(String tenantId, String systemId){
        List<SysTenantMenu> sysTenantMenus= sysTenantMenuService.queryBindMenus(tenantId,systemId);
        sysTenantMenus=sysTenantMenus.stream().filter(f->f.getIsolate()==1).collect(Collectors.toList());
        if(sysTenantMenus.size()==0){
            return new ArrayList<>();
        }
        List<SysMenu>  sysMenus= sysMenuMapper.selectBatchIds(sysTenantMenus.stream().map(f->f.getMenuid()).collect(Collectors.toList()));
        List<String> pathIds=sysMenus.stream().map(f->f.getPathId()).collect(Collectors.toList());
        List<SysMenuPath> sysMenuPaths= sysMenuPathMapper.selectBatchIds(pathIds);
        List<String> systemIds=sysMenuPaths.stream().map(f->f.getPid()).collect(Collectors.toList());
        List<SysSystem> sysSystems= sysSystemMapper.selectBatchIds(systemIds)
                .stream().filter(f->f.getType().equals(SystemTypeEnum.Register.getValue())).collect(Collectors.toList());
        return sysSystems;
    }

}
