package com.geoway.jckj.biz.service.uis.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.geoway.sso.client.config.ProjectConfig;
import com.geoway.jckj.biz.dto.uis.SimpleUserDTO;
import com.geoway.jckj.biz.entity.*;
import com.geoway.jckj.biz.service.dev.unity.IUnityOrganizationService;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserService;
import com.geoway.jckj.biz.service.sys.SysRegionService;
import com.geoway.jckj.biz.service.sys.SysRoleService;
import com.geoway.jckj.biz.service.sys.SysUserRegionService;

import com.geoway.jckj.biz.service.uis.IUISService;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import org.junit.platform.commons.util.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @author 连世忠
 * @ClassName UISServiceImpl
 * @Description TODO
 * @date 2024/3/12 15:44
 * @Version 1.0
 */
@Service
public class UISServiceImpl implements IUISService {
    @Autowired
    private ProjectConfig projectConfig;

    @Autowired
    private IUnityUserService sysUserService;

    @Autowired
    private IUnityOrganizationService sysOrganizationService;

    @Autowired
    private SysRoleService sysRoleService;
    @Autowired
    SysUserRegionService sysUserRegionService;
    @Autowired
    SysRegionService sysRegionService;

    @Override
    public List<SimpleUserDTO> getUserInfo(String token, String userId) {
        List<SimpleUserDTO> arrayList = new ArrayList<>();
        SysUser sysUser = null;
        //token是必传
        if (StringUtils.isBlank(token)) {
            throw new RuntimeException("无效token或token已过期");
        }
        //只传token过来的时候从session中取用户userId
        if (StringUtils.isBlank(userId)) {
            userId= CommonLoginUserUtil.getQueryUserId();
        }
        sysUser=sysUserService.query(userId);
        // ExternalParamDTO dto = new ExternalParamDTO();
        // dto.setUsername(map.get("username"));
        // dto.setTelPhone(map.get("telPhone"));
        //dto.setUserId(userId);
        //sysUser = externalBaseService.queryUserInfo(dto);
        if (ObjectUtil.isNull(sysUser)) {
            throw new RuntimeException("此用户不存在,或当前登录token与用户信息不一致");
        }
        List<SysRole> roles = sysRoleService.queryUserRoles(userId);
        List<SysOrganization> orgs = sysOrganizationService.queryUserOrgs(userId);
        List<SysRegion> regions = sysRegionService.queryUserRegions(userId);

        SimpleUserDTO simpleUser = new SimpleUserDTO().sysUser2simpleUser(sysUser, orgs, roles, regions);
        arrayList.add(simpleUser);
        return arrayList;
    }

    @Override
    public void modifyUserInfo(String id,String  password) {
        String userId = id;
        String userPwd = password;
        if (StringUtils.isBlank(userId) || StringUtils.isBlank(userPwd)) {
            throw new RuntimeException("用户id和密码参数不能为空");
        }
        if (sysUserService.query(userId) == null) {
            throw new RuntimeException("此用户不存在!");
        }
        sysUserService.changePassword(userId, userPwd);
    }

    @Override
    public List<SimpleUserDTO> getUserList(String filterParam) {
        try {
            List<SysUser> userList = sysUserService.queryList(filterParam,false);
            List<SimpleUserDTO> simpleUserList = new ArrayList<>();
            for (SysUser sysUser : userList) {
                SimpleUserDTO simpleUserDTO = new SimpleUserDTO().sysUser2simpleUser(sysUser);
                simpleUserList.add(simpleUserDTO);
            }
            return simpleUserList;
        }catch (Exception exceptions){
            throw new RuntimeException(exceptions);
        }
    }

    @Override
    public List<SysOrganization> getOrgTree(String pid) {
        String myFilterParam = "";
        if (StringUtils.isNotBlank(pid)) {
            myFilterParam = "pid_EQ_" + pid;
        }
        try {
            List<SysOrganization> organizationList = sysOrganizationService.queryTree(myFilterParam,false);
            return organizationList;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<SysOrganization> getOrgInfo(String pid) {
        String myFilterParam = "";
        if (StringUtils.isNotBlank(pid)) {
            myFilterParam = "pid_EQ_" + pid;
        }
        try {
            List<SysOrganization> orgList = sysOrganizationService.queryList(myFilterParam);
           return orgList;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<SysRole> queryRoleTree(String filterParam) {
        try {
            List<SysRole> roleTree = sysRoleService.queryTree(filterParam);
            return roleTree;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }


    @Override
    public List<SysRole> queryRoleList(String filterParam) {
        try {
            if(StrUtil.isEmpty(filterParam)){
                filterParam = "";
            }
            filterParam += ";type_EQ_1";
            List<SysRole> roles = sysRoleService.queryList(filterParam);
            return roles;
        } catch (Exception e) {
            throw new RuntimeException(e);

        }
    }

    @Override
    public List<SysUser> queryRoleUsers(String roleId) {
        try {
            List<SysUser> users = sysRoleService.queryRelUsers(roleId);
            return users;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
