package com.geoway.jckj.biz.util;

import com.geoway.jckj.base.support.spring.SpringUtils;
import com.geoway.jckj.biz.entity.*;
import com.geoway.jckj.biz.service.dev.unity.IUnityOrganizationService;
import com.geoway.jckj.biz.service.sys.SysRoleService;
import com.geoway.jckj.biz.service.sys.SysUserCatalogService;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author 连世忠
 * @ClassName SysUserUtil
 * @Description TODO
 * @date 2025/3/13 17:18
 * @Version 1.0
 */

public class SysUserUtil {
    public static void wrapperUsers(List<SysUser> users){
        wrapperUserRolesNames(users);
        wrapperUserOrgsNames(users);
        wrapperUserCatalogs(users);
    }

    public static void wrapperUserRolesNames(List<SysUser> users) {
        SysRoleService sysRoleService= SpringUtils.getBean(SysRoleService.class);
        for (SysUser user : users) {
            if(user==null){
                continue;
            }
            List<SysRole> roles = sysRoleService.queryUserRoles(user.getId());
            List<String> roleAllNames = roles.stream().map(x -> x.getName()).collect(Collectors.toList());
            user.setRoleNames(roleAllNames);
        }
    }

    public static void wrapperUserOrgsNames(List<SysUser> users) {
        IUnityOrganizationService organizationService=SpringUtils.getBean(IUnityOrganizationService.class);
        for (SysUser user : users) {
            if(user==null){
                continue;
            }
            List<SysOrganization> organizations = organizationService.queryUserOrgs(user.getId());
            List<String> organizationNames = organizations.stream().map(x -> x.getName()).collect(Collectors.toList());
            user.setOrgNames(organizationNames);
        }
    }

    public static void wrapperUserCatalogs(List<SysUser> users){
        SysUserCatalogService userCatalogService=SpringUtils.getBean(SysUserCatalogService.class);
        for (SysUser user : users) {
            if(user==null){
                continue;
            }
            user.setCatalog(userCatalogService.getUserCatalog(user.getId()));
        }
    }


}
