/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.dev.base.impl;

import cn.hutool.core.net.url.UrlQuery;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.geoway.jckj.biz.entity.SysMenu;
import com.geoway.jckj.biz.entity.SysSystem;
import com.geoway.jckj.biz.entity.SysTenant;
import com.geoway.jckj.biz.entity.SysTheme;
import com.geoway.jckj.biz.service.dev.base.IMenuUrlHandlerService;
import com.geoway.jckj.biz.util.TenantUtil;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.springframework.stereotype.Service;

@Service
public class MenuHandlerServiceImpl
implements IMenuUrlHandlerService {
    @Override
    public SysMenu handler(SysSystem sysSystem, SysTheme sysTheme, SysMenu menu) {
        if (menu.getMenuPath() != null && StrUtil.isNotBlank((CharSequence)menu.getMenuPath().getPath())) {
            menu.getMenuPath().setPath(this.replaceDynamicParam(sysSystem, sysTheme, menu, menu.getMenuPath().getPath()));
            menu.getMenuPath().setPath(this.appendSystemParam(sysSystem, sysTheme, menu, menu.getMenuPath().getPath()));
        }
        if (StrUtil.isNotBlank((CharSequence)menu.getPath())) {
            menu.setPath(this.replaceDynamicParam(sysSystem, sysTheme, menu, menu.getPath()));
        }
        if (StrUtil.isNotBlank((CharSequence)menu.getAbsPath())) {
            menu.setAbsPath(this.replaceDynamicParam(sysSystem, sysTheme, menu, menu.getAbsPath()));
            menu.setAbsPath(this.appendSystemParam(sysSystem, sysTheme, menu, menu.getAbsPath()));
        }
        return menu;
    }

    private String replaceDynamicParam(SysSystem sysSystem, SysTheme sysTheme, SysMenu menu, String url) {
        String xzqCodeParam = "{{xzqCode}}";
        String xzqNameParam = "{{xzqName}}";
        String roleIdParam = "{{roleid}}";
        String skinParam = "{{skin}}";
        String menuIdParam = "{{menuid}}";
        String tenantParam = "{{tenantid}}";
        String tenantIdParam = "{{tenantid}}";
        String isolateParam = "{{isolate}}";
        String tokenParam = "{{token}}";
        if (sysTheme != null) {
            url = url.replace(skinParam, sysTheme.getName());
        }
        url = url.replace(menuIdParam, menu.getId());
        SsoUser ssoUser = CommonLoginUserUtil.getUser();
        if (ssoUser == null) {
            return url;
        }
        url = url.replace(xzqCodeParam, ssoUser.getRegionCode());
        url = url.replace(xzqNameParam, ssoUser.getRegionName());
        url = url.replace(xzqNameParam, ssoUser.getRegionName());
        url = url.replace(roleIdParam, ssoUser.getRoldIds());
        url = url.replace(tokenParam, ssoUser.getToken());
        url = url.replace(isolateParam, menu.getIsolate() == null ? "0" : menu.getIsolate().toString());
        SysTenant sysTenant = TenantUtil.getTenant();
        url = url.replace(tenantParam, sysTenant.getKey());
        url = url.replace(tenantIdParam, sysTenant.getId());
        return url;
    }

    private String appendSystemParam(SysSystem sysSystem, SysTheme sysTheme, SysMenu menu, String url) {
        if (!HttpUtil.isHttp((String)url) && !HttpUtil.isHttps((String)url)) {
            return url;
        }
        UrlQuery urlQuery = UrlQuery.of((String)url, (Charset)CharsetUtil.CHARSET_UTF_8);
        HashMap<String, Object> sysParam = new HashMap<String, Object>();
        SsoUser ssoUser = CommonLoginUserUtil.getUser();
        if (ssoUser == null) {
            return url;
        }
        if (StrUtil.isBlank((CharSequence)urlQuery.get((CharSequence)"token"))) {
            sysParam.put("token", ssoUser.getToken());
        }
        if (TenantUtil.isSuperTenant()) {
            return HttpUtil.urlWithForm((String)url, sysParam, (Charset)CharsetUtil.CHARSET_UTF_8, (boolean)true);
        }
        SysTenant sysTenant = TenantUtil.getTenant();
        if (StrUtil.isBlank((CharSequence)urlQuery.get((CharSequence)"tenant"))) {
            sysParam.put("tenant", sysTenant.getKey());
        }
        if (StrUtil.isBlank((CharSequence)urlQuery.get((CharSequence)"tenantid"))) {
            sysParam.put("tenantid", sysTenant.getId());
        }
        if (StrUtil.isBlank((CharSequence)urlQuery.get((CharSequence)"isolate"))) {
            sysParam.put("isolate", menu.getIsolate());
        }
        return HttpUtil.urlWithForm((String)url, sysParam, (Charset)CharsetUtil.CHARSET_UTF_8, (boolean)true);
    }
}

