package com.geoway.jckj.biz.mapper;

import com.geoway.jckj.biz.entity.SysOrganization;
import com.github.yulichang.base.MPJBaseMapper;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author daidongdong
 * @description 针对表【sys_organization】的数据库操作Mapper
 * @createDate 2021-12-02 17:19:38
 * @Entity com.geoway.ns.design.biz.entity.SysOrganization
 */
@Repository
public interface SysOrganizationMapper extends MPJBaseMapper<SysOrganization> {

    /**
     * 查询最大顺序
     *
     * @param pid
     * @return
     */
    Integer queryMaxOrderByPid(String pid);

    /**
     * 查询用户关联组织机构
     *
     * @param userId
     * @return
     */
    List<SysOrganization> queryUserOrgs(String userId);

    /**
     * 得到系统组织签证官
     *
     * @param userId 用户id
     * @return {@link List}<{@link SysOrganizationVO}>
     */
    //List<SysOrganizationVO> getSysOrganizationVO(@Param("userId") String userId);

    /**
     * 按照机构ID递归查询其下所有机构列表
     * @param id  机构ID
     * @return
     */
    List<SysOrganization> getOrgListById(String id);

    /**
     * 按机构ID查询其所有上级机构
     * @param id
     * @return
     */
    List<SysOrganization> getAllParentOrg(String id);

    /**
     * 重置idpath字段的值
     */
    void resetIdPathFieldValue();
}




