package com.geoway.jckj.biz.service.login;

import com.geoway.jckj.base.base.dto.LoginResponse;
import com.geoway.jckj.base.base.dto.OnlineResponse;

import javax.servlet.http.HttpServletRequest;
/**
 * @author ALMJ
 * @desc
 * @date 2021/8/9 18:06
 */
public interface ISysLoginService {

    /**
     * 登入校验
     * @param username
     * @param password
     * @param uuid
     * @param code
     * @param request
     * @return
     */
    LoginResponse checkLogin(String username, String password, String uuid, String code, HttpServletRequest request);

    /**
     * 登入校验
     * @param username
     * @param password
     * @param request
     * @return
     */
    LoginResponse checkLogin(String username, String password, HttpServletRequest request);


    /**
     * 短信验证码登入
     * @param tel
     * @param uuid
     * @param code
     * @param request
     * @return
     */
    LoginResponse checkLoginBySms(String tel, String uuid, String code, HttpServletRequest request);


    /**
     *
     * @param caUserCert
     * @param caOauthName
     * @param request
     * @return
     */
    LoginResponse checkLoginByCa(String caUserCert, String caOauthName, HttpServletRequest request);

    /**
     *
     * @param oneProcessId
     * @param oneToken
     * @param oneAuthCode
     * @param request
     * @return
     */
    LoginResponse checkLoginByOne(String oneProcessId, String oneToken, String oneAuthCode, HttpServletRequest request);

    /**
     * 检查用户是否在线
     * @param username
     * @param password
     * @return
     */
    OnlineResponse checkOnline(String username, String password);

}
