package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.servlet.ServletUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.jckj.base.support.query.MPJQueryMapperUtil;
import com.geoway.jckj.biz.entity.SysMenu;
import com.geoway.jckj.biz.entity.SysSystem;
import com.geoway.jckj.biz.entity.SysOplog;
import com.geoway.jckj.biz.mapper.SysSystemMapper;
import com.geoway.jckj.biz.mapper.SysMenuMapper;
import com.geoway.jckj.biz.mapper.SysOplogMapper;
import com.geoway.jckj.biz.service.ISaasEntityService;
import com.geoway.jckj.biz.service.sys.SysOplogService;
import com.geoway.jckj.biz.util.TenantUtil;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;


@Service
public class SysOplogServiceImpl extends ServiceImpl<SysOplogMapper, SysOplog>
		implements SysOplogService, ISaasEntityService<SysOplog> {

	@Autowired
	SysSystemMapper sysSystemMapper;

	@Autowired
	SysMenuMapper sysMenuMapper;


	@Override
	public boolean save(SysOplog entity) {
		wrapperEntity(entity);
		return super.save(entity);
	}

	@Override
	public List<SysOplog> findByFilterParam(String filterParam) throws Exception {
		MPJLambdaWrapper<SysOplog> queryWrapper =buildLambdaWrapper(filterParam,"");
		return this.list(queryWrapper);
	}
	/**
	 * 获取查询方法
	 * @return
	 */
	@Override
	public  MPJLambdaWrapper<SysOplog> buildLambdaWrapper(String filterParam,String sortParam){
		try {
			if(filterParam==null){
				filterParam="";
			}
			if(sortParam==null){
				sortParam="";
			}
			MPJQueryMapperUtil<SysOplog> qmu = new MPJQueryMapperUtil<>();
			MPJLambdaWrapper<SysOplog> queryWrapper = qmu.queryMapper(filterParam,sortParam, getClassT());
			if(TenantUtil.isSuperTenant()){
                return queryWrapper;
			}
			queryWrapper.eq(SysOplog::getTenantid, getTenantId());
			return queryWrapper;
		}catch (Exception exception){
			throw new RuntimeException(exception);
		}
	}
	@Override
	public IPage<SysOplog> findPageByFilterParam(String filterParam, int page, int size) throws Exception {
		MPJLambdaWrapper<SysOplog> queryWrapper = buildLambdaWrapper(filterParam,"");
		queryWrapper.orderByDesc("f_createtime");
		Page<SysOplog> pages = new Page<>(page, size);
		return this.page(pages,queryWrapper);
	}

	@Override
	public void addMenuOpLog(HttpServletRequest request, String systemKey, String menuId) {

		SsoUser sysUser = CommonLoginUserUtil.getUser();
		if(sysUser == null){
			return;
		}

		SysSystem systemItem = this.queryNsSystemByKey(systemKey);
		if(systemItem == null){
			return;
		}

		List<SysMenu> menuTree = new ArrayList<>();
		buildMenuTree(menuId, menuTree);
		if(menuTree.size() == 0){
			return;
		}
		CollectionUtil.reverse(menuTree);

		String opMenuName = menuTree.stream().map(i ->i.getName()).collect(Collectors.joining(" ->"));
		String ip =  ServletUtil.getClientIP(request);

		String opName = String.format("%s: %s访问了系统菜单(%s)",systemItem.getName(),sysUser.getUserName(),opMenuName);
		JSONObject jsonObject = new JSONObject();
		jsonObject.put("systemId",systemItem.getId());
		jsonObject.put("systemName",systemItem.getName());
		jsonObject.put("menuId",menuId);
		jsonObject.put("menuName",opMenuName);

		SysOplog sysOplog = new SysOplog();
		sysOplog.setUserid(sysUser.getUserid());
		sysOplog.setUsername(sysUser.getUserName());
		sysOplog.setMethod("openMenu");
		sysOplog.setParam(jsonObject.toJSONString());
		sysOplog.setIp(ip);
		sysOplog.setName(opName);
		sysOplog.setDetail(opMenuName);
		sysOplog.setOptype("openMenu");
		sysOplog.setCreatetime(new Date());
		sysOplog.setSystemid(systemItem.getId());
		sysOplog.setAppid(systemItem.getKey());

		this.save(sysOplog);
	}

	private SysSystem queryNsSystemByKey(String key){
		LambdaQueryWrapper<SysSystem> queryWrapper = Wrappers.lambdaQuery();
		queryWrapper.eq(SysSystem::getKey,key);
		queryWrapper.last(" limit 1");

        return sysSystemMapper.selectOne(queryWrapper);
	}

	private void buildMenuTree(String menuId,List<SysMenu> menuTree){

		SysMenu sysMenu = sysMenuMapper.selectById(menuId);
		if(sysMenu == null){
			return;
		}
		menuTree.add(sysMenu);
		if(StrUtil.isNotBlank(sysMenu.getPid()) || "-1".equals(sysMenu.getPid())){
			 this.buildMenuTree(sysMenu.getPid(),menuTree);
		}
	}
}
