package com.geoway.jckj.biz.service.sys.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.jckj.biz.entity.SysMenu;
import com.geoway.jckj.biz.entity.SysRoleMenu;
import com.geoway.jckj.biz.entity.SysRoleSubfunction;
import com.geoway.jckj.biz.entity.SysSubFunction;
import com.geoway.jckj.biz.mapper.SysMenuMapper;
import com.geoway.jckj.biz.mapper.SysRoleMenuMapper;
import com.geoway.jckj.biz.mapper.SysSubFunctionMapper;
import com.geoway.jckj.biz.service.sys.SysRoleSubfunctionService;
import com.geoway.jckj.biz.service.sys.SysRoleMenuService;
import com.github.yulichang.toolkit.JoinWrappers;
import com.github.yulichang.toolkit.MPJWrappers;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
* @author daidongdong
* @description 针对表【sys_role_menu(角色关联菜单表)】的数据库操作Service实现
* @createDate 2024-10-15 17:25:14
*/
@Service
public class SysRoleMenuServiceImpl extends ServiceImpl<SysRoleMenuMapper, SysRoleMenu>
    implements SysRoleMenuService{

    @Autowired
    SysMenuMapper sysMenuMapper;

    @Autowired
    SysSubFunctionMapper sysSubFunctionMapper;

    @Autowired
    SysRoleSubfunctionService sysRoleSubfunctionService;

    @Override
    public List<SysMenu> queryRelateMenus(String roleId, String appId) {

        MPJLambdaWrapper<SysMenu> wrapper = MPJWrappers.lambdaJoin();
        wrapper.leftJoin(SysRoleMenu.class,SysRoleMenu::getMenuid, SysMenu::getId);
        wrapper.eq(SysRoleMenu::getRoleid,roleId);
        wrapper.eq(SysMenu::getSystemId,appId);

        return sysMenuMapper.selectJoinList(SysMenu.class,wrapper);
    }

    @Override
    public void saveRoleMenus(String roleId, String appId, List<String> menuIds) {
        //先删除
        List<String> systemMenuIds = sysMenuMapper.selectList(Wrappers.lambdaQuery(SysMenu.class).eq(SysMenu::getSystemId,appId))
                .stream().map(f->f.getId()).collect(Collectors.toList());
        if(systemMenuIds.size()>0) {
            this.remove(Wrappers.lambdaQuery(SysRoleMenu.class).eq(SysRoleMenu::getRoleid, roleId).in(SysRoleMenu::getMenuid, systemMenuIds));
        }

        //保存菜单信息
        if(menuIds.size() > 0){
            List<SysRoleMenu> roleMenus = new ArrayList<>();
            for(String menuId: menuIds){
                SysRoleMenu roleMenu = new SysRoleMenu();
                roleMenu.setMenuid(menuId);
                roleMenu.setRoleid(roleId);

                roleMenus.add(roleMenu);
            }
            this.saveBatch(roleMenus);
        }

    }

    @Override
    public List<SysSubFunction> queryRelateSubFunctions(String roleId, String menuId) {
        MPJLambdaWrapper<SysSubFunction> wrapper = MPJWrappers.lambdaJoin();
        wrapper.leftJoin(SysRoleSubfunction.class, SysRoleSubfunction::getSubfunctionid, SysSubFunction::getId);
        wrapper.eq(SysRoleSubfunction::getRoleid,roleId);
        wrapper.eq(SysSubFunction::getMenuId,menuId);

        return sysSubFunctionMapper.selectJoinList(SysSubFunction.class,wrapper);

    }

    @Override
    public void saveRoleSubFunctions(String roleId, String menuId, List<String> subFunctionIds) {
        //先删除
        List<String> menuSubFunctionIds = sysSubFunctionMapper.selectList(Wrappers.lambdaQuery(SysSubFunction.class).eq(SysSubFunction::getMenuId,menuId))
                .stream().map(f->f.getId()).collect(Collectors.toList());

        sysRoleSubfunctionService.remove(Wrappers.lambdaQuery(SysRoleSubfunction.class).eq(SysRoleSubfunction::getRoleid,roleId)
                .in(SysRoleSubfunction::getSubfunctionid,menuSubFunctionIds));

        //保存信息
        if(subFunctionIds.size() > 0){
            List<SysRoleSubfunction> sysRoleSubfunctions = new ArrayList<>();
            for(String subFunctionId: subFunctionIds){
                SysRoleSubfunction sysSubFunction = new SysRoleSubfunction();
                sysSubFunction.setSubfunctionid(subFunctionId);
                sysSubFunction.setRoleid(roleId);

                sysRoleSubfunctions.add(sysSubFunction);
            }
            sysRoleSubfunctionService.saveBatch(sysRoleSubfunctions);
        }

    }

    @Override
    public void removeRelateMenus(String roleId, String appId) {
        MPJLambdaWrapper<SysRoleMenu>  joinQueryWrapper = JoinWrappers.lambda();
        joinQueryWrapper.leftJoin(SysMenu.class, SysMenu::getId, SysRoleMenu::getMenuid);
        joinQueryWrapper.eq(SysMenu::getSystemId,appId);
        joinQueryWrapper.eq(SysRoleMenu::getRoleid, roleId);
        List<SysRoleMenu> roleMenus = this.baseMapper.selectJoinList(SysRoleMenu.class,joinQueryWrapper);
        if(roleMenus.size() > 0){
            List<String> roleMenuIds = roleMenus.stream().map( i -> i.getId()).collect(Collectors.toList());
            this.removeByIds(roleMenuIds);
        }
    }
}




