package com.geoway.jckj.biz.service.sys.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.jckj.base.support.StringUtils;
import com.geoway.jckj.biz.entity.SysOrganization;
import com.geoway.jckj.biz.entity.SysRegion;
import com.geoway.jckj.biz.entity.SysTenantOrganization;
import com.geoway.jckj.biz.entity.SysTenantRegion;
import com.geoway.jckj.biz.mapper.SysTenantOrganizationMapper;
import com.geoway.jckj.biz.mapper.SysTenantRegionMapper;
import com.geoway.jckj.biz.service.dev.unity.IUnityOrganizationService;
import com.geoway.jckj.biz.service.sys.SysRegionService;
import com.geoway.jckj.biz.service.sys.SysTenantOrganizationService;
import com.geoway.jckj.biz.service.sys.SysTenantRegionService;
import com.github.yulichang.toolkit.MPJWrappers;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author daidongdong
 * @description 针对表【sys_tenant_menu(租户表)】的数据库操作Service实现
 * @createDate 2025-01-09 17:52:35
 */
@Service
public class SysTenantOrganizationServiceImpl extends ServiceImpl<SysTenantOrganizationMapper, SysTenantOrganization>
        implements SysTenantOrganizationService {

    @Autowired
    IUnityOrganizationService organizationService;
    @Override
    public List<SysOrganization> queryBindOrgs(String tenantId) {
        try{
            MPJLambdaWrapper<SysTenantOrganization> queryWrapper = MPJWrappers.lambdaJoin();
            queryWrapper.eq(SysTenantRegion::getTenantid, tenantId);
            List<SysTenantOrganization> sysTenantOrganizations=this.list(queryWrapper);
            List<SysOrganization> orgs=new ArrayList<>();
            List<String> orgIds=sysTenantOrganizations.stream().map(f->f.getOrgid()).collect(Collectors.toList());
            for(String orgId:orgIds){
                SysOrganization   sysOrganization=organizationService.findOneById(orgId,"");
                if(sysOrganization!=null){
                    sysOrganization.setChildren(null);
                    orgs.add(sysOrganization);
                }
            }
            return orgs;
        }catch (Exception e){
            throw new RuntimeException(e);
        }

    }

    @Override
    public void bindOrgs(String tenantId, List<String> orgIds) {
        LambdaQueryWrapper<SysTenantOrganization> menuWrapper = Wrappers.lambdaQuery();
        menuWrapper.eq(SysTenantOrganization::getTenantid,tenantId);
        this.remove(menuWrapper);
        List<SysTenantOrganization> tenantOrganizations=new ArrayList<>();
        for(String orgId:orgIds){
            SysTenantOrganization tenantOrganization=new SysTenantOrganization();
            tenantOrganization.setOrgid(orgId);
            tenantOrganization.setTenantid(tenantId);
            tenantOrganizations.add(tenantOrganization);
        }
        this.saveBatch(tenantOrganizations);
    }

    @Override
    public void bindOrgs(String tenantId, String orgIds) {
        if(StringUtils.isEmpty(orgIds)){
            orgIds="";
        }
        String[] orgIdArr = orgIds.split(",");
        bindOrgs(tenantId,Arrays.asList(orgIdArr));
    }
}




