package com.geoway.jckj.biz.util;

import com.geoway.jckj.base.support.StringUtils;
import com.geoway.jckj.base.support.spring.SpringUtils;
import com.geoway.jckj.biz.entity.SysOrganization;
import com.geoway.jckj.biz.entity.SysRegion;
import com.geoway.jckj.biz.entity.SysRole;
import com.geoway.jckj.biz.entity.SysTenant;
import com.geoway.jckj.biz.service.dev.unity.IUnityOrganizationService;
import com.geoway.jckj.biz.service.sys.SysRegionService;
import com.geoway.jckj.biz.service.sys.SysRoleService;
import com.geoway.jckj.biz.service.sys.SysTenantService;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;
import org.springframework.web.context.support.ServletRequestHandledEvent;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import static com.geoway.jckj.biz.constants.TenantConstants.AdminTenantId;
import static com.geoway.jckj.biz.constants.TenantConstants.AdminTenantKey;

/**
 * @author 连世忠
 * @ClassName TenantUtil
 * @Description TODO
 * @date 2025/3/20 8:38
 * @Version 1.0
 */
@Component
public class TenantUtil implements ApplicationListener<ServletRequestHandledEvent> {

    private static ThreadLocal<SysTenant> threadLocalTenant=new ThreadLocal<>();
    private static ThreadLocal<List<String>> threadLocalRegionIds=new ThreadLocal<>();
    private static ThreadLocal<List<String>> threadLocalOrgIds=new ThreadLocal<>();
    private static ThreadLocal<List<String>> threadLocalRoleIds=new ThreadLocal<>();
    /**
     *获取租户信息
     * @return
     */
    public static SysTenant getTenant(){
        if(threadLocalTenant.get()!=null){
            return threadLocalTenant.get();
        }
        SysTenantService sysTenantService= SpringUtils.getBean(SysTenantService.class);
        String tenantId = getTenantId();
        SysTenant sysTenant=null;
        if(tenantId.equals(AdminTenantId)){
            sysTenant=new SysTenant();
            sysTenant.setId(AdminTenantId);
            sysTenant.setKey(AdminTenantKey);

        }else{
            sysTenant=sysTenantService.getById(tenantId);
            if(sysTenant==null){
                throw new RuntimeException("未获取到租户信息");
            }
        }
        threadLocalTenant.set(sysTenant);
        return sysTenant;

    }

    /**
     * 获取租户ID
     * @return
     */
    public  static String getTenantId(){
        if(threadLocalTenant.get()!=null){
            return threadLocalTenant.get().getId();
        }
        String tenantId = CommonLoginUserUtil.getTenantID();
        if(StringUtils.isNotEmpty(tenantId)&&!tenantId.equals(AdminTenantId)) {
            return tenantId;
        }
        String tenantKey= CommonLoginUserUtil.getTenantKey();
        SysTenantService sysTenantService= SpringUtils.getBean(SysTenantService.class);
        if(StringUtils.isNotEmpty(tenantKey)){
            if(AdminTenantKey.equals(tenantKey)){
                return AdminTenantId;
            }
            SysTenant sysTenant=sysTenantService.queryByKey(tenantKey);
            if(sysTenant==null){
                throw new RuntimeException("未获取到租户信息");
            }
            threadLocalTenant.set(sysTenant);
            return sysTenant.getId();
        }
        return AdminTenantId;
        //String userId=CommonLoginUserUtil.getUserId();
        //List<SysTenant> sysTenants=sysTenantService.queryByUserId(userId);
        //if(sysTenants.size()==1){
            //return sysTenants.get(0).getId();
       // }else if(sysTenants.size()>1){
            //throw new RuntimeException("请指定租户空间");
        //}else{
           // return "0";
        //}
    }


    public  static boolean isSuperTenant(){
        String tenantId=getTenantId();
        return tenantId.equals(AdminTenantId);
    }

    public static List<String> getTenantOrgIds(){
        if(threadLocalOrgIds.get()!=null){
            return threadLocalOrgIds.get();
        }
        IUnityOrganizationService organizationService=SpringUtils.getBean(IUnityOrganizationService.class);
        SysTenant sysTenant=getTenant();
        if(sysTenant.getId().equals(AdminTenantId)){
            return new ArrayList<>();
        }
        List<String>  orgs=new ArrayList<>();
        List<String> manageOrgs = sysTenant.getOrganizations().stream().map(SysOrganization::getId).collect(Collectors.toList());
        // 查询下级组织
        for (String orgId : manageOrgs) {
            orgs.addAll(organizationService.queryAllChildOrg(orgId).stream().map(SysOrganization::getId).collect(Collectors.toList()));
        }
        threadLocalOrgIds.set(orgs);
        return orgs;
    }

    public static List<String> getTenantRegionIds(){
        if(threadLocalRegionIds.get()!=null){
            return threadLocalRegionIds.get();
        }
        SysRegionService sysRegionService=SpringUtils.getBean(SysRegionService.class);
        SysTenant sysTenant=getTenant();
        if(sysTenant.getId().equals(AdminTenantId)){
            return new ArrayList<>();
        }
        List<String>  regions=new ArrayList<>();
        List<String>  manageRegions = sysTenant.getRegions().stream().map(SysRegion::getId).collect(Collectors.toList());
        // 查询下级组织
        for (String regionId : manageRegions) {
            regions.addAll(sysRegionService.queryRegionListById(regionId).stream().map(SysRegion::getId).collect(Collectors.toList()));
        }
        //regions.addAll(manageRegions);
        threadLocalRegionIds.set(regions);
        return regions;
    }

    public static List<String> getTeantRoleIds(){
        if(threadLocalRoleIds.get()!=null){
            return threadLocalRoleIds.get();
        }
        SysRoleService sysRoleService=SpringUtils.getBean(SysRoleService.class);
        List<SysRole> roles=sysRoleService.queryList("");
        List<String> roleIds=roles.stream().map(f->f.getId()).collect(Collectors.toList());
        threadLocalRoleIds.set(roleIds);
        return roleIds;
    }

    @Override
    public void onApplicationEvent(ServletRequestHandledEvent event) {
        threadLocalTenant.set(null);
        threadLocalRegionIds.set(null);
        threadLocalOrgIds.set(null);
        threadLocalRoleIds.set(null);
    }
}
