/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.uis.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.geoway.jckj.biz.dto.uis.SimpleUserDTO;
import com.geoway.jckj.biz.entity.SysOrganization;
import com.geoway.jckj.biz.entity.SysRegion;
import com.geoway.jckj.biz.entity.SysRole;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.service.dev.unity.IUnityOrganizationService;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserService;
import com.geoway.jckj.biz.service.sys.SysRegionService;
import com.geoway.jckj.biz.service.sys.SysRoleService;
import com.geoway.jckj.biz.service.sys.SysUserRegionService;
import com.geoway.jckj.biz.service.uis.IUISService;
import com.geoway.sso.client.config.ProjectConfig;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import java.util.ArrayList;
import java.util.List;
import org.junit.platform.commons.util.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UISServiceImpl
implements IUISService {
    @Autowired
    private ProjectConfig projectConfig;
    @Autowired
    private IUnityUserService sysUserService;
    @Autowired
    private IUnityOrganizationService sysOrganizationService;
    @Autowired
    private SysRoleService sysRoleService;
    @Autowired
    SysUserRegionService sysUserRegionService;
    @Autowired
    SysRegionService sysRegionService;

    @Override
    public List<SimpleUserDTO> getUserInfo(String token, String userId) {
        ArrayList<SimpleUserDTO> arrayList = new ArrayList<SimpleUserDTO>();
        SysUser sysUser = null;
        if (StringUtils.isBlank((String)token)) {
            throw new RuntimeException("\u65e0\u6548token\u6216token\u5df2\u8fc7\u671f");
        }
        if (StringUtils.isBlank((String)userId)) {
            userId = CommonLoginUserUtil.getQueryUserId();
        }
        if (ObjectUtil.isNull((Object)(sysUser = this.sysUserService.query(userId)))) {
            throw new RuntimeException("\u6b64\u7528\u6237\u4e0d\u5b58\u5728,\u6216\u5f53\u524d\u767b\u5f55token\u4e0e\u7528\u6237\u4fe1\u606f\u4e0d\u4e00\u81f4");
        }
        List<SysRole> roles = this.sysRoleService.queryUserRoles(userId);
        List<SysOrganization> orgs = this.sysOrganizationService.queryUserOrgs(userId);
        List<SysRegion> regions = this.sysRegionService.queryUserRegions(userId);
        SimpleUserDTO simpleUser = new SimpleUserDTO().sysUser2simpleUser(sysUser, orgs, roles, regions);
        arrayList.add(simpleUser);
        return arrayList;
    }

    @Override
    public void modifyUserInfo(String id, String password) {
        String userId = id;
        String userPwd = password;
        if (StringUtils.isBlank((String)userId) || StringUtils.isBlank((String)userPwd)) {
            throw new RuntimeException("\u7528\u6237id\u548c\u5bc6\u7801\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (this.sysUserService.query(userId) == null) {
            throw new RuntimeException("\u6b64\u7528\u6237\u4e0d\u5b58\u5728!");
        }
        this.sysUserService.changePassword(userId, userPwd);
    }

    @Override
    public List<SimpleUserDTO> getUserList(String filterParam) {
        try {
            List<SysUser> userList = this.sysUserService.queryList(filterParam, false);
            ArrayList<SimpleUserDTO> simpleUserList = new ArrayList<SimpleUserDTO>();
            for (SysUser sysUser : userList) {
                SimpleUserDTO simpleUserDTO = new SimpleUserDTO().sysUser2simpleUser(sysUser);
                simpleUserList.add(simpleUserDTO);
            }
            return simpleUserList;
        }
        catch (Exception exceptions) {
            throw new RuntimeException(exceptions);
        }
    }

    @Override
    public List<SysOrganization> getOrgTree(String pid) {
        String myFilterParam = "";
        if (StringUtils.isNotBlank((String)pid)) {
            myFilterParam = "pid_EQ_" + pid;
        }
        try {
            List<SysOrganization> organizationList = this.sysOrganizationService.queryTree(myFilterParam, false);
            return organizationList;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<SysOrganization> getOrgInfo(String pid) {
        String myFilterParam = "";
        if (StringUtils.isNotBlank((String)pid)) {
            myFilterParam = "pid_EQ_" + pid;
        }
        try {
            List<SysOrganization> orgList = this.sysOrganizationService.queryList(myFilterParam);
            return orgList;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<SysRole> queryRoleTree(String filterParam) {
        try {
            List<SysRole> roleTree = this.sysRoleService.queryTree(filterParam);
            return roleTree;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<SysRole> queryRoleList(String filterParam) {
        try {
            if (StrUtil.isEmpty((CharSequence)filterParam)) {
                filterParam = "";
            }
            filterParam = filterParam + ";type_EQ_1";
            List<SysRole> roles = this.sysRoleService.queryList(filterParam);
            return roles;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<SysUser> queryRoleUsers(String roleId) {
        try {
            List<SysUser> users = this.sysRoleService.queryRelUsers(roleId);
            return users;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

