package com.geoway.jckj.biz.mapper;

import com.geoway.jckj.biz.entity.SysUser;
import com.github.yulichang.base.MPJBaseMapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author daidongdong
 * @description 针对表【sys_user】的数据库操作Mapper
 * @createDate 2021-12-20 17:06:21
 * @Entity com.geoway.ns.design.biz.entity.SysUser
 */
@Repository
public interface SysUserMapper extends MPJBaseMapper<SysUser> {

    /**
     * 查询组织机构关联用户
     *
     * @param name
     * @return
     */
    List<SysUser> queryUsersInOrg(String name);

    /**
     * 查询角色关联用户
     *
     * @param roleId
     * @return
     */
    List<SysUser> queryRolerUsers(String roleId);

    /**
     * 查询组织机构关联用户
     *
     * @param roleId
     * @return
     */
    List<SysUser> queryOrgUsers(String roleId);

    /**
     * 查询所有组织机构用户
     *
     * @return
     */
    List<SysUser> queryAllOrgUsers();



    /**
     * 查询无机构用户列表
     * @return
     */
    List<SysUser> queryAllNonOrgUsers();

    @Select("SELECT count(1) FROM( #{sqlView} ) sqlViewT ")
    Integer queryCountBySqlView(@Param("sqlView")String sqlView);
}




