package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.geoway.jckj.base.support.StringUtils;
import com.geoway.jckj.base.support.query.MPJQueryMapperUtil;
import com.geoway.jckj.biz.entity.*;
import com.geoway.jckj.biz.mapper.*;
import com.geoway.jckj.biz.service.dev.unity.IUnityOrganizationService;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserService;
import com.geoway.jckj.biz.service.sys.*;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.github.yulichang.toolkit.MPJWrappers;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author wangqiang
 * @description 针对表【sys_tenant(租户表)】的数据库操作Service实现
 * @createDate 2025-01-02 09:40:39
 */
@Service
public class SysTenantServiceImpl extends MPJBaseServiceImpl<SysTenantMapper, SysTenant>
        implements SysTenantService {
    @Autowired
    private SysUserTenantService sysUserTenantService;
    @Autowired
    private SysTenantRegionService sysTenantRegionService;
    @Autowired
    private SysTenantOrganizationService sysTenantOrganizationService;
    @Autowired
    private SysTenantSystemService sysTenantSystemService;

    @Override
    public boolean saveOrUp(SysTenant sysTenant) {
        LambdaQueryWrapper<SysTenant> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysTenant::getName, sysTenant.getName());
        if(StrUtil.isNotBlank(sysTenant.getId())){
            wrapper.ne(SysTenant::getId, sysTenant.getId());
        }
        Integer one = this.count(wrapper);
        if(one>0){
            throw new RuntimeException("名称【"+ sysTenant.getName()+"】已存在！");
        }
        wrapper.or().eq(SysTenant::getKey, sysTenant.getKey());
        one = this.count(wrapper);
        if(one>0){
            throw new RuntimeException("关键字【"+ sysTenant.getKey()+"】已存在！");
        }
        if(StringUtils.isEmpty(sysTenant.getId())){
            sysTenant.setId("gw"+System.currentTimeMillis());
        }
        return this.saveOrUpdate(sysTenant);
    }
    @Override
    public SysTenant getById(Serializable id) {
        SysTenant sysTenant= getBaseMapper().selectById(id);
        if(sysTenant==null){
            return sysTenant;
        }
        wapperSysTenant(sysTenant);
        return sysTenant;
    }
    @Transactional
    @Override
    public void delete(String id) {
        List<SysUserTenant> users = sysUserTenantService.list(Wrappers.lambdaQuery(SysUserTenant.class)
                .eq(SysUserTenant::getTenantid, id).select(SysUserTenant::getUserid));
        // 删除租户下的用户
        sysUserTenantService.removeBindUsers(id,users.stream().map(SysUserTenant::getUserid).collect(Collectors.joining(",")));
        // 删除租户
        this.removeById(id);
    }

    private  MPJLambdaWrapper<SysTenant> buildMPJLambdaWrapper(String filterParam){
        try {
            MPJQueryMapperUtil<SysTenant> qmu = new MPJQueryMapperUtil<>();
            MPJLambdaWrapper<SysTenant> queryWrapper = qmu.queryMapper(filterParam, SysTenant.class);
            queryWrapper.orderByAsc(SysTenant::getCreatetime);
            queryWrapper.leftJoin(SysUserTenant.class, SysUserTenant::getTenantid, SysTenant::getId);
            queryWrapper.selectAll(SysTenant.class);
            //queryWrapper.selectCollection(SysUser.class,SysTenant::getUsers);
            queryWrapper.distinct();
            return queryWrapper;
        }catch (Exception e){
            throw new RuntimeException(e);
        }
    }

    private void wapperSysTenants(List<SysTenant> tenants){
        tenants.forEach(f->wapperSysTenant(f));
    }

    private void wapperSysTenant(SysTenant tenant){

        List<SysSystem> systemNames =  sysTenantSystemService.queryBindSystems(tenant.getId());
        tenant.setSystems(systemNames);

        List<SysUser> sysUsers=sysUserTenantService.queryBindUsers(tenant.getId());
        tenant.setUsers(sysUsers);


        List<SysRegion> sysRegions=sysTenantRegionService.queryBindRegions(tenant.getId());
        tenant.setRegions(sysRegions);

        List<SysOrganization>  sysOrganizations=sysTenantOrganizationService.queryBindOrgs(tenant.getId());
        tenant.setOrganizations(sysOrganizations);
    }

    @Override
    public IPage<SysTenant> queryPage(String filterParam, Integer page, Integer size) throws Exception {
        MPJLambdaWrapper<SysTenant> queryWrapper=buildMPJLambdaWrapper(filterParam);
        Page<SysTenant> pages = new Page<>(page, size);
        IPage<SysTenant> pageTenants = this.selectJoinListPage(pages,SysTenant.class,queryWrapper);
        wapperSysTenants(pageTenants.getRecords());
        return pageTenants;
    }

    @Override
    public SysTenant queryByKey(String key) {
        MPJLambdaWrapper<SysTenant> queryWrapper = MPJWrappers.lambdaJoin();
        queryWrapper.eq(SysTenant::getKey,key);
        SysTenant sysTenant=this.getOne(queryWrapper);
        if(sysTenant==null){
            return sysTenant;
        }
        wapperSysTenant(sysTenant );
        return sysTenant;
    }

    @Override
    public List<SysTenant> queryByUserId(String userId) {
        MPJLambdaWrapper<SysTenant> queryWrapper=buildMPJLambdaWrapper("");
        queryWrapper.eq(SysUserTenant::getUserid,userId);
        List<SysTenant> sysTenants=this.selectJoinList(SysTenant.class,queryWrapper);
        wapperSysTenants(sysTenants);
        return sysTenants;
    }


}




