package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.sso.client.enums.RoleLevelEnum;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.entity.SysUserLimit;
import com.geoway.jckj.biz.mapper.SysUserLimitMapper;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserLimitService;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserService;
import com.geoway.jckj.biz.service.sys.SysUserLimitService;

import com.github.yulichang.base.MPJBaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
* @author daidongdong
* @description 针对表【sys_user_limit】的数据库操作Service实现
* @createDate 2024-09-21 15:20:08
*/
@Service
public class SysUserLimitServiceImpl extends MPJBaseServiceImpl<SysUserLimitMapper, SysUserLimit>
    implements SysUserLimitService {

    private final int const_blacklist = 1;
    private final int const_whitelist = 2;

    @Autowired
    IUnityUserService unityUserService;

    @Autowired
    IUnityUserLimitService unityUserLimitService;

    @Override
    public void saveOneLimit(SysUserLimit userLimit) throws Exception {

        String userId = userLimit.getUserid();
        //SsoUser ssoUser = this.getCurrentUser();
        SysUser sysUser = unityUserService.query(userId);
        if(sysUser != null && sysUser.getCatalog() == RoleLevelEnum.superAdmin.getValue()){
            throw  new Exception("超级管理员不能加入黑名单");
        }

        boolean isNew = true;
        if(StrUtil.isNotBlank(userLimit.getId())){
            isNew = this.getById(userLimit.getId()) == null;
        }

        if(isNew){
            LambdaQueryWrapper<SysUserLimit> queryWrapper =  Wrappers.lambdaQuery();
            queryWrapper.eq(SysUserLimit::getUserid,userLimit.getUserid());
            queryWrapper.eq(SysUserLimit::getAppid,userLimit.getAppid());
            queryWrapper.last(" limit 1");

            SysUserLimit existLimit = this.getOne(queryWrapper);
            if(existLimit != null){
                userLimit.setId(existLimit.getId());
            }else{
                userLimit.setCreatetime(new Date());
            }
        }
        this.saveOrUpdate(userLimit);
    }

    @Override
    public void bactchSaveWithJSON(String jsonArrayStr) throws Exception {
        List<SysUserLimit> userLimits = JSONArray.parseArray(jsonArrayStr,SysUserLimit.class);
        if(userLimits != null){
            for (SysUserLimit userLimit: userLimits){
                this.saveOneLimit(userLimit);
            }
        }
    }

    @Override
    public boolean isValid(String appId,String userId) {
        boolean isValid = true;
        LambdaQueryWrapper<SysUserLimit> queryWrapper =  Wrappers.lambdaQuery();
        queryWrapper.eq(SysUserLimit::getUserid,userId);

        List<SysUserLimit> userLimits = this.list(queryWrapper);
        for(SysUserLimit userLimit: userLimits){
            boolean appIdValid = userLimit.getAppid().equals("-1") || userLimit.getAppid().equals(appId);
            boolean timeValid = userLimit.getExpiretime() == null || userLimit.getExpiretime().getTime() > System.currentTimeMillis();
            if(userLimit.getLimittype() == const_blacklist && appIdValid && timeValid){
                isValid = false;
                break;
            }
        }

        return isValid;
    }

    @Override
    public IPage<SysUserLimit> queryPage(String filterParam, String sortParam,String username,String tel, int page, int size) throws Exception {
       return  unityUserLimitService.queryPage(filterParam,sortParam,username,tel,page,size);
    }
}




