package com.geoway.jckj.biz.util;

import cn.hutool.core.util.StrUtil;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.base.support.encryption.AESUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * @author 连世忠
 * @ClassName TelUtil
 * @Description TODO
 * @date 2025/5/21 11:51
 * @Version 1.0
 */
@Component
public class PhoneNumberUtil {

    @Value("${userTel.encrypt:true}")
    private boolean userTelEncrypt;

    public boolean isTelEncrypt(){
        return userTelEncrypt;
    }

    public String getHidePhoneNumber(String realPhoneNumber){
        if(StrUtil.isBlank(realPhoneNumber)||realPhoneNumber.length()<11){
            return realPhoneNumber;
        }
       // 手机号隐藏中间4位
        return realPhoneNumber.substring(0, 3) + "****" + realPhoneNumber.substring(7, 11);
    }

    public String getEncryptPhoneNumber(String realPhoneNumber){
        try {
            if(StrUtil.isBlank(realPhoneNumber)){
                return "";
            }
            return AESUtils.encrypt(realPhoneNumber, AESUtils.KEY);
        }catch (Exception exception){
            throw new ServiceException(exception.getMessage(),exception);
        }
    }
    public String getDecryptPhoneNumber(String encryptPhoneNumber){
        try {
            String tel = AESUtils.decrypt(encryptPhoneNumber, AESUtils.KEY);
            return tel;
        }catch (Exception exception){
            throw new ServiceException(exception.getMessage(),exception);
        }
    }
    public String convertPhoneNumberFilterParam(String filterParam) throws Exception {
        if (StrUtil.isBlank(filterParam)) {
            return filterParam;
        }
        String telStr = "tel_EQ_";
        String telEncryptStr = "telEncrypt_EQ_";
        if (!filterParam.contains(telStr)) {
            return filterParam;
        }
        int index = filterParam.indexOf(telStr);
        String sub1 = filterParam.substring(index);
        int i1 = sub1.indexOf(";");

        int i2 = sub1.indexOf(")");
        String sub2 = sub1;
        if (i1 > 0 || i2 > 0) {
            if (i1 > 0 && i2 > 0) {
                sub2 = sub1.substring(0, Math.min(i1, i2));
            } else {
                sub2 = sub1.substring(0, Math.max(i1, i2));
            }
        }
        String telValue = sub2.replace(telStr, "");
        String encryptValue =getEncryptPhoneNumber(telValue);
        return filterParam.replace(sub2, telEncryptStr + encryptValue);
    }
    
}
