/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.login.impl;

import com.geoway.jckj.base.base.dto.LoginResponse;
import com.geoway.jckj.base.base.dto.OnlineResponse;
import com.geoway.jckj.base.config.SsoConfigProp;
import com.geoway.jckj.biz.service.login.ISysLoginService;
import com.geoway.jckj.biz.service.oauth2.IOauth2Service;
import com.geoway.jckj.biz.service.sys.SysUserOnlineService;
import com.geoway.sso.client.config.ProjectConfig;
import com.geoway.sso.client.enums.GrantTypeEnum;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.SessionUtils;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SysLoginServiceImpl
implements ISysLoginService {
    @Autowired
    private ProjectConfig projectConfig;
    @Autowired
    private IOauth2Service ssoOauth2Service;
    @Autowired
    private SysUserOnlineService sysUserOnlineService;
    @Autowired
    private SsoConfigProp ssoConfigProp;

    @Override
    public LoginResponse checkLogin(String username, String password, String uuid, String code, HttpServletRequest request) {
        RpcAccessToken rpcAccessToken = this.ssoOauth2Service.getAccessToken(GrantTypeEnum.PASSWORD_CAPTCHA.getValue(), this.projectConfig.getSsoAppId(), this.projectConfig.getSsoAppSecret(), "", username, password, "", uuid, code);
        SessionUtils.setAccessToken((HttpServletRequest)request, (RpcAccessToken)rpcAccessToken);
        return this.getLoginResponse(rpcAccessToken, "sso");
    }

    @Override
    public LoginResponse checkLogin(String username, String password, HttpServletRequest request) {
        RpcAccessToken rpcAccessToken = this.ssoOauth2Service.getAccessToken(GrantTypeEnum.PASSWORD.getValue(), this.projectConfig.getSsoAppId(), this.projectConfig.getSsoAppSecret(), "", username, password, "", "", "");
        SessionUtils.setAccessToken((HttpServletRequest)request, (RpcAccessToken)rpcAccessToken);
        return this.getLoginResponse(rpcAccessToken, "sso");
    }

    @Override
    public LoginResponse checkLoginBySms(String tel, String uuid, String code, HttpServletRequest request) {
        RpcAccessToken rpcAccessToken = this.ssoOauth2Service.getAccessToken(GrantTypeEnum.TEL_CAPTCHA.getValue(), this.projectConfig.getSsoAppId(), this.projectConfig.getSsoAppSecret(), "", "", "", tel, uuid, code);
        SessionUtils.setAccessToken((HttpServletRequest)request, (RpcAccessToken)rpcAccessToken);
        return this.getLoginResponse(rpcAccessToken, "sms");
    }

    @Override
    public LoginResponse checkLoginByCa(String caUserCert, String caOauthName, HttpServletRequest request) {
        RpcAccessToken rpcAccessToken = this.ssoOauth2Service.getAccessToken(GrantTypeEnum.TEL_CAPTCHA.getValue(), this.projectConfig.getSsoAppId(), this.projectConfig.getSsoAppSecret(), "", "", "", "", "", "", caUserCert, caOauthName, "", "", "");
        SessionUtils.setAccessToken((HttpServletRequest)request, (RpcAccessToken)rpcAccessToken);
        return this.getLoginResponse(rpcAccessToken, "ca");
    }

    @Override
    public LoginResponse checkLoginByOne(String oneProcessId, String oneToken, String oneAuthCode, HttpServletRequest request) {
        RpcAccessToken rpcAccessToken = this.ssoOauth2Service.getAccessToken(GrantTypeEnum.ONE.getValue(), this.projectConfig.getSsoAppId(), this.projectConfig.getSsoAppSecret(), "", "", "", "", "", "", "", "", oneProcessId, oneToken, oneAuthCode);
        SessionUtils.setAccessToken((HttpServletRequest)request, (RpcAccessToken)rpcAccessToken);
        return this.getLoginResponse(rpcAccessToken, "ca");
    }

    @Override
    public OnlineResponse checkOnline(String username, String password) {
        OnlineResponse response = new OnlineResponse();
        boolean isLogin = this.sysUserOnlineService.isOnline(username, password);
        response.setSingeUser(this.ssoConfigProp.getSingeUser().booleanValue());
        response.setLogin(isLogin);
        return response;
    }

    private LoginResponse getLoginResponse(RpcAccessToken rpcAccessToken, String validType) {
        LoginResponse response = new LoginResponse();
        SsoUser user = rpcAccessToken.getUser();
        response.setAlisName(user.getUserName());
        response.setAliasName(user.getUserName());
        response.setToken(rpcAccessToken.getAccessToken());
        response.setUserId(user.getId());
        response.setUserName(user.getLoginName());
        response.setRefreshToken(rpcAccessToken.getRefreshToken());
        response.setStatus("OK");
        response.setValidateType(validType);
        response.setPasswordPolicy((Object)user.getPasswordPolicy());
        response.setUserCatalog(user.getUserCatalog());
        response.setRegionCode(user.getRegionCode());
        response.setRegionName(user.getRegionName());
        return response;
    }
}

