/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.entity.SysUserLimit;
import com.geoway.jckj.biz.mapper.SysUserLimitMapper;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserLimitService;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserService;
import com.geoway.jckj.biz.service.sys.SysUserLimitService;
import com.geoway.sso.client.enums.RoleLevelEnum;
import com.github.yulichang.base.MPJBaseServiceImpl;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysUserLimitServiceImpl
extends MPJBaseServiceImpl<SysUserLimitMapper, SysUserLimit>
implements SysUserLimitService {
    private final int const_blacklist = 1;
    private final int const_whitelist = 2;
    @Autowired
    IUnityUserService unityUserService;
    @Autowired
    IUnityUserLimitService unityUserLimitService;

    @Override
    public void saveOneLimit(SysUserLimit userLimit) throws Exception {
        String userId = userLimit.getUserid();
        SysUser sysUser = this.unityUserService.query(userId);
        if (sysUser != null && sysUser.getCatalog().intValue() == RoleLevelEnum.superAdmin.getValue()) {
            throw new Exception("\u8d85\u7ea7\u7ba1\u7406\u5458\u4e0d\u80fd\u52a0\u5165\u9ed1\u540d\u5355");
        }
        boolean isNew = true;
        if (StrUtil.isNotBlank((CharSequence)userLimit.getId())) {
            boolean bl = isNew = this.getById((Serializable)((Object)userLimit.getId())) == null;
        }
        if (isNew) {
            LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.eq(SysUserLimit::getUserid, (Object)userLimit.getUserid());
            queryWrapper.eq(SysUserLimit::getAppid, (Object)userLimit.getAppid());
            queryWrapper.last(" limit 1");
            SysUserLimit existLimit = (SysUserLimit)this.getOne((Wrapper)queryWrapper);
            if (existLimit != null) {
                userLimit.setId(existLimit.getId());
            } else {
                userLimit.setCreatetime(new Date());
            }
        }
        this.saveOrUpdate(userLimit);
    }

    @Override
    public void bactchSaveWithJSON(String jsonArrayStr) throws Exception {
        List userLimits = JSONArray.parseArray((String)jsonArrayStr, SysUserLimit.class);
        if (userLimits != null) {
            for (SysUserLimit userLimit : userLimits) {
                this.saveOneLimit(userLimit);
            }
        }
    }

    @Override
    public boolean isValid(String appId, String userId) {
        boolean isValid = true;
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysUserLimit::getUserid, (Object)userId);
        List userLimits = this.list((Wrapper)queryWrapper);
        for (SysUserLimit userLimit : userLimits) {
            boolean timeValid;
            boolean appIdValid = userLimit.getAppid().equals("-1") || userLimit.getAppid().equals(appId);
            boolean bl = timeValid = userLimit.getExpiretime() == null || userLimit.getExpiretime().getTime() > System.currentTimeMillis();
            if (userLimit.getLimittype() != 1 || !appIdValid || !timeValid) continue;
            isValid = false;
            break;
        }
        return isValid;
    }

    @Override
    public IPage<SysUserLimit> queryPage(String filterParam, String sortParam, String username, String tel, int page, int size) throws Exception {
        return this.unityUserLimitService.queryPage(filterParam, sortParam, username, tel, page, size);
    }
}

