package com.geoway.jckj.biz.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.geoway.jckj.base.annotation.SwaggerInputFieldIgnore;
import com.github.yulichang.annotation.EntityMapping;
import lombok.Data;
import lombok.experimental.FieldNameConstants;

import java.io.Serializable;
import java.util.List;

/**
 * 
 * @TableName sys_menu
 */
@TableName(value ="sys_menu")
@Data
@FieldNameConstants
public class SysMenu extends  SaasEntity implements Serializable {
    /**
     * id
     */
    @TableId(value = "f_id",type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 名称
     */
    @TableField(value = "f_name")
    private String name;

    /**
     * 菜单关键字
     */
    @TableField(value = "f_key")
    private String key;

    /**
     * 上级id
     */
    @TableField(value = "f_pid")
    private String pid;

    /**
     * 路径id
     */
    @TableField(value = "f_pathid",updateStrategy= FieldStrategy.IGNORED)
    private String pathId;

    /**
     * 排序
     */
    @TableField(value = "f_sort")
    private Integer sort;

    /**
     * 对应系统id
     */
    @TableField(value = "f_systemid")
    private String systemId;

    /**
     * 菜单分组(1.普通菜单 2.个人中心菜单）
     */
    @TableField(value = "f_group")
    private Integer group;

    /**
     * 菜单类型（1.原始菜单 2.挂接菜单）
     */
    @TableField(value = "f_menutype")
    private Integer menuType;

    /**
     * 关联菜单id
     */
    @TableField(value = "f_relmenuid",updateStrategy= FieldStrategy.IGNORED)
    private String relMenuId;

    /**
     * 打开方式（1.单页面 2.iframe 3.x新页面）
     */
    @TableField(value = "f_openmode")
    private Integer openMode;

    /**
     * 是否缓存
     */
    @TableField(value = "f_iscache")
    private Integer isCache;

    /**
     * 是否免登录
     */
    @TableField(value = "f_nologin")
    private Integer nologin = 0;

    /**
     * 是否免登录
     */
    @TableField(value = "f_isdefault")
    private Integer isdefault = 0;


    /**
     * 菜单icon
     */
    @TableField(value = "f_icon")
    private String icon;

    /**
     * 激活图标base64
     */
    @TableField(value = "f_activeicon")
    private String activeIcon;

    /**
     * 是否资源隔离
     */
    @TableField(exist = false)
    private Integer isolate = 0;

    /**
     * 菜单路径
     */
    @TableField(exist = false)
    private String path;

    /**
     * 路径类型（1.相对路径 2.绝对路径）
     */
    @TableField(exist = false)
    private Integer pathType;


    @TableField(exist = false)
    @EntityMapping(thisField = Fields.pathId, joinField = SysMenuPath.Fields.id)
    private SysMenuPath menuPath;

    /**
     * 菜单绝对路径
     */
    @TableField(exist = false)
    private String absPath;


    /**
     * 子菜单
     */
    @TableField(exist = false)
    @EntityMapping(thisField = Fields.id, joinField = Fields.pid, orderByAsc = Fields.sort )
    @SwaggerInputFieldIgnore
    private List<SysMenu> children;

    @Override
    public boolean equals(Object obj) {

        SysMenu menu = (SysMenu) obj;
        return this.id == menu.id;
    }

}