package com.geoway.jckj.biz.service.dev.base.impl;

import cn.hutool.core.util.StrUtil;
import com.geoway.sso.client.config.ProjectConfig;
import com.geoway.jckj.biz.entity.SysRegion;
import com.geoway.jckj.biz.entity.SysTenant;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.mapper.SysRegionMapper;
import com.geoway.jckj.biz.service.dev.base.ILoginService;
import com.geoway.jckj.biz.service.login.ICaptchaService;
import com.geoway.jckj.biz.service.sys.SysRoleService;
import com.geoway.jckj.biz.service.sys.SysTenantService;
import com.geoway.jckj.biz.util.SysUserUtil;
import com.geoway.sso.client.enums.RoleLevelEnum;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.Oauth2Utils;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author 连世忠
 * @ClassName AbstractLoginServiceImpl
 * @Description TODO
 * @date 2024/3/14 15:01
 * @Version 1.0
 */
public  abstract class AbstractLoginServiceImpl implements ILoginService {
    @Autowired
    private ProjectConfig projectConfig;
    @Autowired
    private ICaptchaService commonService;

    @Autowired
    private SysRegionMapper sysRegionMapper;

    @Autowired
    private SysTenantService sysTenantService;

    @Autowired
    private SysRoleService sysRoleService;

    @Override
    public Result<SsoUser> loginByOne(String processId, String token, String authCode, HttpServletRequest req) {
        throw new RuntimeException("手机一键登入");
    }

    @Override
    public Result<SsoUser> loginByCa(String caUserCert, String caOauthName, HttpServletRequest req) {
        throw new RuntimeException("暂不支持CA认证登入");
    }

    @Override
    public Result<SsoUser> loginBySms(String tel, String uuid, String code, HttpServletRequest req) {
        throw new RuntimeException("暂不支持手机号验证码登入");
    }

    @Override
    public  abstract  Result<SsoUser> login(String username, String password, String uuid, String code, HttpServletRequest req);



    @Override
    public Result<SsoUser> login(String username, String password) {
        Result<SsoUser>  result = login(username,password,null,null,null);
        return result;
    }

    @Override
    public boolean loginOut(HttpServletRequest request, String access_token) {
        Result<RpcAccessToken> result = Oauth2Utils.revokeAccessToken(projectConfig.getSsoServerUrl(),access_token);
        return result.isSuccess();
    }

    protected void validateCaptcha(String uuid,String code){
        try {
            if (StrUtil.isEmpty(uuid) && StrUtil.isEmpty(code)) {
                return;
            }
            // 获取session中验证码
            String captcha = commonService.queryCaptcha(uuid);
            if (!commonService.validateCaptcha(code, captcha)) {
                throw new RuntimeException("验证码已过期或有误，请重新试试!");
            }
        }finally {

        }
    }

    protected SsoUser convertToSsoUser(SysUser user){
        SsoUser ssoUser = new SsoUser();
        SysUserUtil.wrapperUsers(Collections.singletonList(user));
        List<SysRegion> regions = sysRegionMapper.queryUserRegions(user.getId());
        String regionCode = regions.stream().map(i -> i.getCode()).collect(Collectors.joining(","));
        String regionName = regions.stream().map(i -> i.getName()).collect(Collectors.joining(","));
        if(user.getCatalog().equals(RoleLevelEnum.tenantAdmin.getValue())){
            List<SysTenant> sysTenants=sysTenantService.queryByUserId(user.getId());
            String tenant=sysTenants.stream().map(f->f.getId()).collect(Collectors.joining(","));
            ssoUser.setTenantIds(tenant);
        }
        ssoUser.setRoldIds(sysRoleService.queryUserRoles(user.getId()).stream().map(f->f.getId()).collect(Collectors.joining(",")));
        ssoUser.setId(user.getId());
        ssoUser.setUserid(user.getId());
        ssoUser.setUserName(user.getAname());
        ssoUser.setLoginName(user.getName());
        ssoUser.setRegionCode(regionCode);
        ssoUser.setRegionName(regionName);
        ssoUser.setUserCatalog(user.getCatalog());
        ssoUser.setSource(user.getSource());
        return ssoUser;
    }
}
