package com.geoway.jckj.biz.service.oauth2.impl;

import com.geoway.jckj.biz.service.oauth2.IOauth2Service;
import com.geoway.sso.client.enums.GrantTypeEnum;
import com.geoway.sso.client.oauth2.IOauth2Utils;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;

/**
 * @author 连世忠
 * @ClassName IOauth2UtilsImpl
 * @Description TODO
 * @date 2025/5/20 15:42
 * @Version 1.0
 */
@Component
@ConditionalOnExpression("#{T(com.geoway.sso.client.constant.SystemConstant).IS_SERVER}")
//@ConditionalOnExpression("!'${sso.server.url:}'.isEmpty()")
public class Oauth2UtilsImpl implements IOauth2Utils {
    @Autowired
    private IOauth2Service oauth2Service;
    @Override
    public Result<RpcAccessToken> getAccessToken(String serverUrl, String appId, String appSecret, String username, String password) {
        RpcAccessToken rpcAccessToken=oauth2Service.getAccessToken(GrantTypeEnum.PASSWORD.getValue(),appId,appSecret,"",username,password,"","","");
        return Result.createSuccess(rpcAccessToken);
    }

    @Override
    public Result<RpcAccessToken> getAccessToken(String serverUrl, String appId, String appSecret, String username, String password, String uuid, String code) {
        RpcAccessToken rpcAccessToken=oauth2Service.getAccessToken(GrantTypeEnum.PASSWORD_CAPTCHA.getValue(),appId,appSecret,"",username,password,"",uuid,code);
        return Result.createSuccess(rpcAccessToken);
    }

    @Override
    public Result<RpcAccessToken> getAccessTokenBySms(String serverUrl, String appId, String appSecret, String tel, String uuid, String code) {
        RpcAccessToken rpcAccessToken=oauth2Service.getAccessToken(GrantTypeEnum.TEL_CAPTCHA.getValue(),appId,appSecret,"","","",tel,uuid,code);
        return Result.createSuccess(rpcAccessToken);
    }

    @Override
    public Result<RpcAccessToken> getAccessTokenByOne(String serverUrl, String appId, String appSecret, String processId, String token, String authCode) {
        RpcAccessToken rpcAccessToken=oauth2Service.getAccessToken(GrantTypeEnum.ONE.getValue(),appId,appSecret,"","","","","","","","",processId,token,authCode);
        return Result.createSuccess(rpcAccessToken);
    }

    @Override
    public Result<RpcAccessToken> getAccessTokenByCa(String serverUrl, String appId, String appSecret, String caUserCert, String caOauthName) {
        RpcAccessToken rpcAccessToken=oauth2Service.getAccessToken(GrantTypeEnum.CA.getValue(),appId,appSecret,"","","","","","",caUserCert,caOauthName,"","","");
        return Result.createSuccess(rpcAccessToken);
    }

    @Override
    public Result<RpcAccessToken> getAccessTokenByCode(String serverUrl, String appId, String appSecret, String code) {
        RpcAccessToken rpcAccessToken=oauth2Service.getAccessToken(GrantTypeEnum.AUTHORIZATION_CODE.getValue(),appId,appSecret,code,"","","","","");
        if(rpcAccessToken==null){
            return Result.createError("获取token失败");
        }
        return Result.createSuccess(rpcAccessToken);
    }

    @Override
    public Result<RpcAccessToken> refreshToken(String serverUrl, String appId, String refreshToken) {
        RpcAccessToken rpcAccessToken=oauth2Service.refreshToken(appId,refreshToken);
        if(rpcAccessToken==null){
            return Result.createError("刷新token失败");
        }
        return Result.createSuccess(rpcAccessToken);
    }

    @Override
    public Result<RpcAccessToken> queryAccessToken(String serverUrl, String accessToken) {
        RpcAccessToken rpcAccessToken=oauth2Service.queryAccessToken(accessToken);
        if(rpcAccessToken==null){
            return Result.createError("获取token失败");
        }
        return Result.createSuccess(rpcAccessToken);
    }

    @Override
    public Result<RpcAccessToken> revokeAccessToken(String serverUrl, String accessToken) {
        oauth2Service.revokeAccessToken(accessToken);
        return Result.createSuccess();
    }
}
