/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.dev.base.impl;

import cn.hutool.core.util.StrUtil;
import com.geoway.jckj.biz.entity.SysRegion;
import com.geoway.jckj.biz.entity.SysTenant;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.mapper.SysRegionMapper;
import com.geoway.jckj.biz.service.dev.base.ILoginService;
import com.geoway.jckj.biz.service.login.ICaptchaService;
import com.geoway.jckj.biz.service.sys.SysRoleService;
import com.geoway.jckj.biz.service.sys.SysTenantService;
import com.geoway.jckj.biz.util.SysUserUtil;
import com.geoway.sso.client.enums.RoleLevelEnum;
import com.geoway.sso.client.provider.RpcClientInfoProvider;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.Oauth2Utils;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractLoginServiceImpl
implements ILoginService {
    @Autowired
    private ICaptchaService commonService;
    @Autowired
    private SysRegionMapper sysRegionMapper;
    @Autowired
    private SysTenantService sysTenantService;
    @Autowired
    private SysRoleService sysRoleService;
    @Autowired
    private RpcClientInfoProvider rpcClientInfoProvider;

    @Override
    public Result<SsoUser> loginByOne(String processId, String token, String authCode, HttpServletRequest req) {
        throw new RuntimeException("\u624b\u673a\u4e00\u952e\u767b\u5165");
    }

    @Override
    public Result<SsoUser> loginByCa(String caUserCert, String caOauthName, HttpServletRequest req) {
        throw new RuntimeException("\u6682\u4e0d\u652f\u6301CA\u8ba4\u8bc1\u767b\u5165");
    }

    @Override
    public Result<SsoUser> loginBySms(String tel, String uuid, String code, HttpServletRequest req) {
        throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u624b\u673a\u53f7\u9a8c\u8bc1\u7801\u767b\u5165");
    }

    @Override
    public abstract Result<SsoUser> login(String var1, String var2, String var3, String var4, HttpServletRequest var5);

    @Override
    public Result<SsoUser> login(String username, String password) {
        Result<SsoUser> result = this.login(username, password, null, null, null);
        return result;
    }

    @Override
    public boolean loginOut(HttpServletRequest request, String access_token) {
        Result result = Oauth2Utils.revokeAccessToken((String)this.rpcClientInfoProvider.getRpcClientInfo().getServerUrl(), (String)access_token);
        return result.isSuccess();
    }

    protected void validateCaptcha(String uuid, String code) {
        if (StrUtil.isEmpty((CharSequence)uuid) && StrUtil.isEmpty((CharSequence)code)) {
            return;
        }
        String captcha = this.commonService.queryCaptcha(uuid);
        if (!this.commonService.validateCaptcha(code, captcha)) {
            throw new RuntimeException("\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f\u6216\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8bd5\u8bd5!");
        }
    }

    protected SsoUser convertToSsoUser(SysUser user) {
        SsoUser ssoUser = new SsoUser();
        SysUserUtil.wrapperUsers(Collections.singletonList(user));
        List<SysRegion> regions = this.sysRegionMapper.queryUserRegions(user.getId());
        String regionCode = regions.stream().map(i -> i.getCode()).collect(Collectors.joining(","));
        String regionName = regions.stream().map(i -> i.getName()).collect(Collectors.joining(","));
        if (user.getCatalog().equals(RoleLevelEnum.tenantAdmin.getValue())) {
            List<SysTenant> sysTenants = this.sysTenantService.queryByUserId(user.getId());
            String tenant = sysTenants.stream().map(f -> f.getId()).collect(Collectors.joining(","));
            ssoUser.setTenantIds(tenant);
        }
        ssoUser.setRoldIds(this.sysRoleService.queryUserRoles(user.getId()).stream().map(f -> f.getId()).collect(Collectors.joining(",")));
        ssoUser.setId(user.getId());
        ssoUser.setUserid(user.getId());
        ssoUser.setUserName(user.getAname());
        ssoUser.setLoginName(user.getName());
        ssoUser.setRegionCode(regionCode);
        ssoUser.setRegionName(regionName);
        ssoUser.setUserCatalog(user.getCatalog());
        ssoUser.setSource(user.getSource());
        return ssoUser;
    }
}

