/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.sys.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.jckj.base.support.StringUtils;
import com.geoway.jckj.biz.entity.SysOrganization;
import com.geoway.jckj.biz.entity.SysTenantOrganization;
import com.geoway.jckj.biz.entity.SysTenantRegion;
import com.geoway.jckj.biz.mapper.SysTenantOrganizationMapper;
import com.geoway.jckj.biz.service.dev.unity.IUnityOrganizationService;
import com.geoway.jckj.biz.service.sys.SysTenantOrganizationService;
import com.github.yulichang.toolkit.MPJWrappers;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysTenantOrganizationServiceImpl
extends ServiceImpl<SysTenantOrganizationMapper, SysTenantOrganization>
implements SysTenantOrganizationService {
    @Autowired
    IUnityOrganizationService organizationService;

    @Override
    public List<SysOrganization> queryBindOrgs(String tenantId) {
        try {
            MPJLambdaWrapper queryWrapper = MPJWrappers.lambdaJoin();
            queryWrapper.eq(SysTenantRegion::getTenantid, (Object)tenantId);
            List sysTenantOrganizations = this.list((Wrapper)queryWrapper);
            ArrayList<SysOrganization> orgs = new ArrayList<SysOrganization>();
            List orgIds = sysTenantOrganizations.stream().map(f -> f.getOrgid()).collect(Collectors.toList());
            for (String orgId : orgIds) {
                SysOrganization sysOrganization = this.organizationService.findOneById(orgId, "");
                if (sysOrganization == null) continue;
                sysOrganization.setChildren(null);
                orgs.add(sysOrganization);
            }
            return orgs;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void bindOrgs(String tenantId, List<String> orgIds) {
        LambdaQueryWrapper menuWrapper = Wrappers.lambdaQuery();
        menuWrapper.eq(SysTenantOrganization::getTenantid, (Object)tenantId);
        this.remove((Wrapper)menuWrapper);
        ArrayList<SysTenantOrganization> tenantOrganizations = new ArrayList<SysTenantOrganization>();
        for (String orgId : orgIds) {
            SysTenantOrganization tenantOrganization = new SysTenantOrganization();
            tenantOrganization.setOrgid(orgId);
            tenantOrganization.setTenantid(tenantId);
            tenantOrganizations.add(tenantOrganization);
        }
        this.saveBatch(tenantOrganizations);
    }

    @Override
    public void bindOrgs(String tenantId, String orgIds) {
        if (StringUtils.isEmpty((String)orgIds)) {
            orgIds = "";
        }
        String[] orgIdArr = orgIds.split(",");
        this.bindOrgs(tenantId, Arrays.asList(orgIdArr));
    }
}

