/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.jckj.biz.entity.SysSystem;
import com.geoway.jckj.biz.entity.SysTenant;
import com.geoway.jckj.biz.entity.SysTenantMenu;
import com.geoway.jckj.biz.entity.SysTenantSpace;
import com.geoway.jckj.biz.entity.SysTenantSystem;
import com.geoway.jckj.biz.enums.SystemTypeEnum;
import com.geoway.jckj.biz.enums.TenantSpaceStatusEnum;
import com.geoway.jckj.biz.mapper.SysMenuMapper;
import com.geoway.jckj.biz.mapper.SysMenuPathMapper;
import com.geoway.jckj.biz.mapper.SysSystemMapper;
import com.geoway.jckj.biz.mapper.SysTenantMapper;
import com.geoway.jckj.biz.mapper.SysTenantSpaceMapper;
import com.geoway.jckj.biz.mapper.SysTenantSystemMapper;
import com.geoway.jckj.biz.service.sys.SysTenantMenuService;
import com.geoway.jckj.biz.service.sys.SysTenantSpaceService;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import com.geoway.sso.client.util.HttpUtils;
import com.github.yulichang.base.MPJBaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysTenantSpaceServiceImpl
extends MPJBaseServiceImpl<SysTenantSpaceMapper, SysTenantSpace>
implements SysTenantSpaceService {
    @Autowired
    private SysTenantMenuService sysTenantMenuService;
    @Autowired
    private SysMenuMapper sysMenuMapper;
    @Autowired
    private SysMenuPathMapper sysMenuPathMapper;
    @Autowired
    private SysSystemMapper sysSystemMapper;
    @Autowired
    private SysTenantMapper sysTenantMapper;
    @Autowired
    private SysTenantSystemMapper sysTenantSystemMapper;
    private static final String TENANT_SPACE_CREATE_URL = "/tenant/createSpace";

    @Override
    public TenantSpaceStatusEnum checkSpaceStatus(String tenantId, String systemId) {
        List<SysSystem> sysSystems = this.getRelRegisterSystems(tenantId, systemId);
        if (sysSystems.size() == 0) {
            return TenantSpaceStatusEnum.None;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysTenantSpace::getTenantid, (Object)tenantId);
        wrapper.eq(SysTenantSpace::getSpaceStatus, (Object)1);
        List sysTenantSpaces = this.list((Wrapper)wrapper);
        List solateIds = sysTenantSpaces.stream().map(f -> f.getSystemid()).collect(Collectors.toList());
        if (sysSystems.stream().anyMatch(f -> !solateIds.contains(f.getId()))) {
            return TenantSpaceStatusEnum.notCreated;
        }
        return TenantSpaceStatusEnum.created;
    }

    @Override
    public boolean createTenantSpace(String tenantId, String systemId) {
        List<String> systemIds = null;
        if (StrUtil.isBlank((CharSequence)systemId)) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysTenantSystem::getTenantid, (Object)tenantId);
            systemIds = this.sysTenantSystemMapper.selectList((Wrapper)wrapper).stream().map(f -> f.getSystemid()).collect(Collectors.toList());
        } else {
            systemIds = Arrays.asList(systemId.split(","));
        }
        systemIds.forEach(f -> this.createTenantSpaceOne(tenantId, (String)f));
        return true;
    }

    private boolean createTenantSpaceOne(String tenantId, String systemId) {
        List<SysSystem> sysSystems = this.getRelRegisterSystems(tenantId, systemId);
        if (sysSystems.size() == 0) {
            return true;
        }
        SysSystem noSystem = sysSystems.stream().filter(f -> StrUtil.isBlank((CharSequence)f.getBackendUrl())).findFirst().orElse(null);
        if (noSystem != null) {
            throw new RuntimeException(String.format("\u3010%s\u3011\u7cfb\u7edf\u672a\u914d\u7f6e\u540e\u7aef\u5730\u5740\uff0c\u8bf7\u6838\u67e5", noSystem.getName()));
        }
        SysTenant sysTenant = (SysTenant)this.sysTenantMapper.selectById((Serializable)((Object)tenantId));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantKey", sysTenant.getKey());
        HashMap<String, String> header = new HashMap<String, String>();
        HashMap<String, String> cacheUrls = new HashMap<String, String>();
        header.put("access_token", CommonLoginUserUtil.getToken());
        for (SysSystem system : sysSystems) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysTenantSpace::getTenantid, (Object)tenantId);
            wrapper.eq(SysTenantSpace::getSystemid, (Object)system.getId());
            SysTenantSpace sysTenantSpace = (SysTenantSpace)this.getOne((Wrapper)wrapper);
            if (sysTenantSpace != null) continue;
            if (!cacheUrls.containsKey(system.getBackendUrl())) {
                try {
                    String url = system.getBackendUrl() + TENANT_SPACE_CREATE_URL;
                    Result result = HttpUtils.postHttp((String)url, paramMap, header, null, Void.class);
                    if (result == null) {
                        throw new RuntimeException(String.format("\u3010%s\u3011\u7cfb\u7edf\u521b\u5efa\u79df\u6237\u7a7a\u95f4\u5931\u8d25\uff0c\u8bf7\u6838\u67e5", system.getName()));
                    }
                    if (!result.isSuccess()) {
                        throw new RuntimeException(String.format("\u3010%s\u3011\u7cfb\u7edf\u521b\u5efa\u79df\u6237\u7a7a\u95f4\u5931\u8d25:%s\uff0c\u8bf7\u6838\u67e5", system.getName(), result.getMessage()));
                    }
                    cacheUrls.put(system.getBackendUrl(), system.getBackendUrl());
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
            sysTenantSpace = new SysTenantSpace();
            sysTenantSpace.setSpaceStatus(TenantSpaceStatusEnum.created.getValue());
            sysTenantSpace.setSystemid(system.getId());
            sysTenantSpace.setTenantid(tenantId);
            this.save(sysTenantSpace);
        }
        return true;
    }

    private List<SysSystem> getRelRegisterSystems(String tenantId, String systemId) {
        List<SysTenantMenu> sysTenantMenus = this.sysTenantMenuService.queryBindMenus(tenantId, systemId);
        if ((sysTenantMenus = sysTenantMenus.stream().filter(f -> f.getIsolate() == 1).collect(Collectors.toList())).size() == 0) {
            return new ArrayList<SysSystem>();
        }
        List sysMenus = this.sysMenuMapper.selectBatchIds(sysTenantMenus.stream().map(f -> f.getMenuid()).collect(Collectors.toList()));
        List pathIds = sysMenus.stream().map(f -> f.getPathId()).collect(Collectors.toList());
        List sysMenuPaths = this.sysMenuPathMapper.selectBatchIds(pathIds);
        List systemIds = sysMenuPaths.stream().map(f -> f.getPid()).collect(Collectors.toList());
        List<SysSystem> sysSystems = this.sysSystemMapper.selectBatchIds(systemIds).stream().filter(f -> f.getType().equals(SystemTypeEnum.Register.getValue())).collect(Collectors.toList());
        return sysSystems;
    }
}

