/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.base.support.encryption.AESUtils;
import com.geoway.jckj.base.support.query.MPJQueryMapperUtil;
import com.geoway.jckj.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.jckj.biz.dto.UserRelParams;
import com.geoway.jckj.biz.entity.SysOrganization;
import com.geoway.jckj.biz.entity.SysRegion;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.entity.SysUserRegister;
import com.geoway.jckj.biz.enums.TenantUserRangeEnum;
import com.geoway.jckj.biz.mapper.SysUserRegisterMapper;
import com.geoway.jckj.biz.service.dev.unity.IUnityOrganizationService;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserService;
import com.geoway.jckj.biz.service.sys.SysRegionService;
import com.geoway.jckj.biz.service.sys.SysUserRegisterService;
import com.geoway.jckj.biz.service.sys.SysUserRoleService;
import com.geoway.jckj.biz.util.PhoneNumberUtil;
import com.geoway.jckj.biz.util.TenantUtil;
import com.geoway.sso.client.config.ProjectConfig;
import com.geoway.sso.client.enums.RoleLevelEnum;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SysUserRegisterServiceImpl
extends ServiceImpl<SysUserRegisterMapper, SysUserRegister>
implements SysUserRegisterService {
    @Resource
    private IUnityUserService sysUserService;
    @Resource
    private IUnityOrganizationService organizationService;
    @Resource
    private SysRegionService sysRegionService;
    @Resource
    private SysUserRoleService sysUserRoleService;
    @Value(value="${userRegister.auditMode:2}")
    private int auditMode;
    @Resource
    private PhoneNumberUtil phoneNumberUtil;
    @Resource
    private ProjectConfig projectConfig;

    @Override
    public Boolean checkAccoutRepeat(String accout) throws Exception {
        List<SysUser> users = this.sysUserService.queryList("name_EQ_" + accout);
        List<SysUserRegister> usersRegister = this.queryList("name_EQ_" + accout + ";auditState_NE_2");
        return users.size() > 0 || usersRegister.size() > 0;
    }

    @Override
    public Boolean checkTelRepeat(String tel) throws Exception {
        List<SysUser> users = this.sysUserService.queryList("tel_EQ_" + tel);
        List<SysUserRegister> usersRegister = this.queryList("tel_EQ_" + tel + ";auditState_NE_2");
        return users.size() > 0 || usersRegister.size() > 0;
    }

    @Override
    public Boolean registerUser(SysUserRegister sysUserRegister) {
        String tel = sysUserRegister.getTel();
        if (StringUtils.isBlank((CharSequence)tel)) {
            throw new ServiceException("\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (tel.length() != 11) {
            throw new RuntimeException("\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef");
        }
        try {
            sysUserRegister.setTelEncrypt(AESUtils.encrypt((String)tel, (String)"FWAijk4A2Dwt2MKw"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        sysUserRegister.setTel(tel.substring(0, 3) + "****" + tel.substring(7, 11));
        this.save(sysUserRegister);
        return true;
    }

    @Override
    public IPage<SysUserRegister> queryPage(String filterParam, int page, int size) throws Exception {
        Page pages = new Page((long)page, (long)size);
        if (this.phoneNumberUtil.isTelEncrypt()) {
            filterParam = this.phoneNumberUtil.convertPhoneNumberFilterParam(filterParam);
        }
        Integer userCatalog = CommonLoginUserUtil.getUser().getUserCatalog();
        MPJQueryMapperUtil mpjQueryMapperUtil = new MPJQueryMapperUtil();
        MPJLambdaWrapper queryWrapper = mpjQueryMapperUtil.queryMapper(filterParam, SysUserRegister.class);
        if (userCatalog == null || userCatalog > RoleLevelEnum.tenantAdmin.getValue()) {
            return pages;
        }
        if (userCatalog.intValue() == RoleLevelEnum.tenantAdmin.getValue()) {
            TenantUserRangeEnum userRangeEnum = TenantUserRangeEnum.getEnumByValue(this.projectConfig.getTenantUserRange());
            List<String> regions = TenantUtil.getTenantRegionIds();
            List<String> orgs = TenantUtil.getTenantOrgIds();
            if (userRangeEnum == TenantUserRangeEnum.REGION && regions.size() == 0) {
                return pages;
            }
            if (userRangeEnum == TenantUserRangeEnum.ORG && orgs.size() == 0) {
                return pages;
            }
            if (userRangeEnum == TenantUserRangeEnum.REGION_ORG && orgs.size() == 0 && regions.size() == 0) {
                return pages;
            }
            queryWrapper.and(wrapper -> {
                if (regions.size() > 0) {
                    wrapper.in(SysUserRegister::getRegion, (Collection)regions);
                }
                if (orgs.size() > 0) {
                    ((MPJLambdaWrapper)wrapper.or()).in(SysUserRegister::getOrganization, (Collection)orgs);
                }
            });
        }
        queryWrapper.orderByAsc((Object)"f_createtime");
        IPage pageUsers = ((SysUserRegisterMapper)this.baseMapper).selectPage((IPage)pages, (Wrapper)queryWrapper);
        for (SysUserRegister register : pageUsers.getRecords()) {
            if (StringUtils.isNotBlank((CharSequence)register.getOrganization())) {
                SysOrganization organization = this.organizationService.findOneById(register.getOrganization(), "");
                organization.setAllname(StrUtil.join((CharSequence)"/", (Iterable)this.organizationService.queryAllParentOrg(organization.getId()).stream().map(SysOrganization::getName).collect(Collectors.toList())));
                register.setOrgNames(organization.getAllname());
            }
            if (StringUtils.isNotBlank((CharSequence)register.getRegion())) {
                SysRegion sysRegion = (SysRegion)this.sysRegionService.getById((Serializable)((Object)register.getRegion()));
                sysRegion.setAllname(StrUtil.join((CharSequence)"/", (Iterable)this.sysRegionService.queryAllParentRegionById(sysRegion.getId()).stream().map(SysRegion::getName).collect(Collectors.toList())));
                register.setRegionNames(sysRegion.getAllname());
            }
            if (!StringUtils.isNotBlank((CharSequence)register.getAuditUser())) continue;
            register.setAuditUserName(this.sysUserService.query(register.getAuditUser()).getName());
        }
        return pageUsers;
    }

    @Override
    public List<SysUserRegister> queryList(String filterParam) throws Exception {
        if (this.phoneNumberUtil.isTelEncrypt()) {
            filterParam = this.phoneNumberUtil.convertPhoneNumberFilterParam(filterParam);
        }
        MyBatisQueryMapperUtils qmu = new MyBatisQueryMapperUtils();
        QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysUserRegister.class);
        queryWrapper.orderByAsc((Object)"f_createtime");
        List users = ((SysUserRegisterMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        return users;
    }

    @Override
    public Boolean audit(String userId, String id, Boolean passed, String auditOpinion, String roleIds) throws Exception {
        if (StringUtils.isBlank((CharSequence)userId)) {
            return false;
        }
        SysUserRegister entity = (SysUserRegister)this.getById((Serializable)((Object)id));
        if (entity == null) {
            return false;
        }
        entity.setAuditState(Boolean.TRUE.equals(passed) ? "1" : "2");
        entity.setAuditOpinion(auditOpinion);
        entity.setAuditTime(new Date());
        entity.setAuditUser(userId);
        this.updateById(entity);
        if ("1".equals(entity.getAuditState())) {
            SysUser sysUser = new SysUser();
            BeanUtil.copyProperties((Object)entity, (Object)sysUser, (boolean)true);
            sysUser.setId(null);
            sysUser.setCatalog(RoleLevelEnum.commonUser.getValue());
            if (entity.getKind() == 1) {
                UserRelParams userRelParams = new UserRelParams();
                if (StrUtil.isNotBlank((CharSequence)entity.getOrganization())) {
                    userRelParams.setOrganizations(Arrays.asList(entity.getOrganization().split(",")));
                }
                userRelParams.setRegions(Arrays.asList(entity.getRegion()));
                sysUser.setOtherParams(JSON.toJSONString((Object)userRelParams));
            }
            this.sysUserService.saveOrUp(sysUser, null, false);
            if (StrUtil.isNotBlank((CharSequence)roleIds)) {
                this.sysUserRoleService.updateUserRole(sysUser.getId(), Arrays.asList(roleIds.split(",")));
            }
        }
        return true;
    }
}

