/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.biz.entity.SysRole;
import com.geoway.jckj.biz.entity.SysSystem;
import com.geoway.jckj.biz.entity.SysTenant;
import com.geoway.jckj.biz.entity.SysTenantMenu;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.entity.SysUserCatalog;
import com.geoway.jckj.biz.entity.SysUserTenant;
import com.geoway.jckj.biz.mapper.SysSystemMapper;
import com.geoway.jckj.biz.mapper.SysTenantMapper;
import com.geoway.jckj.biz.mapper.SysUserTenantMapper;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserService;
import com.geoway.jckj.biz.service.sys.SysRoleMenuService;
import com.geoway.jckj.biz.service.sys.SysRoleService;
import com.geoway.jckj.biz.service.sys.SysRoleSystemService;
import com.geoway.jckj.biz.service.sys.SysTenantMenuService;
import com.geoway.jckj.biz.service.sys.SysTenantSystemService;
import com.geoway.jckj.biz.service.sys.SysUserCatalogService;
import com.geoway.jckj.biz.service.sys.SysUserRoleService;
import com.geoway.jckj.biz.service.sys.SysUserTenantService;
import com.geoway.sso.client.enums.RoleLevelEnum;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SysUserTenantServiceImpl
extends ServiceImpl<SysUserTenantMapper, SysUserTenant>
implements SysUserTenantService {
    private static final String TENANT_ADMIN_ROLE_NAME = "\u79df\u6237\u7ba1\u7406\u5458\u89d2\u8272";
    private static final String TENANT_ADMIN_ROLE_GROUP_NAME = "\u79df\u6237\u7ba1\u7406\u5458";
    @Autowired
    SysTenantSystemService sysTenantSystemService;
    @Autowired
    SysSystemMapper sysSystemMapper;
    @Autowired
    SysUserTenantMapper sysUserTenantMapper;
    @Autowired
    SysRoleService sysRoleService;
    @Autowired
    SysTenantMenuService sysTenantMenuService;
    @Autowired
    IUnityUserService unityUserService;
    @Autowired
    SysUserCatalogService sysUserCatalogService;
    @Autowired
    SysRoleSystemService sysRoleSystemService;
    @Autowired
    SysTenantMapper sysTenantMapper;
    @Autowired
    SysRoleMenuService sysRoleMenuService;
    @Autowired
    private SysUserRoleService sysUserRoleService;

    @Override
    public void removeBindUsers(String tenantId, String userIds) {
        if (StrUtil.isBlank((CharSequence)tenantId) || StrUtil.isBlank((CharSequence)userIds)) {
            return;
        }
        List<String> userIdList = Arrays.asList(userIds.split(","));
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysUserTenant::getTenantid, (Object)tenantId);
        queryWrapper.in(SysUserTenant::getUserid, userIdList);
        this.sysUserTenantMapper.delete((Wrapper)queryWrapper);
        userIdList.forEach(f -> this.removeDefaultRole(tenantId, (String)f));
        queryWrapper.clear();
        queryWrapper.in(SysUserTenant::getUserid, userIdList);
        List userTenants = this.list((Wrapper)queryWrapper);
        List mapUserIds = userTenants.stream().map(i -> i.getUserid()).collect(Collectors.toList());
        ArrayList<String> userValidIds = new ArrayList<String>();
        for (String userId : userIdList) {
            if (mapUserIds.contains(userId)) continue;
            userValidIds.add(userId);
        }
        userValidIds.forEach(userValidId -> {
            SysUserCatalog sysUserCatalog = new SysUserCatalog();
            sysUserCatalog.setUserCatalog(RoleLevelEnum.commonUser.getValue());
            sysUserCatalog.setUserid((String)userValidId);
            this.sysUserCatalogService.saveOrUp(sysUserCatalog);
        });
    }

    @Override
    public List<SysUser> queryBindUsers(String tenantId) {
        List<SysUserTenant> userTenants = this.getBindUsers(tenantId);
        return this.unityUserService.query(userTenants.stream().map(f -> f.getUserid()).collect(Collectors.toList()));
    }

    private List<SysUserTenant> getBindUsers(String tenantId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysUserTenant::getTenantid, (Object)tenantId);
        List userTenants = this.list((Wrapper)queryWrapper);
        return userTenants;
    }

    @Override
    public IPage<SysUser> queryPageUsers(String filterParam, String tenantId, int page, int size) {
        List<SysUserTenant> userTenants;
        if (StrUtil.isBlank((CharSequence)filterParam)) {
            filterParam = "";
        }
        if (StrUtil.isNotBlank((CharSequence)filterParam)) {
            filterParam = filterParam + ";";
        }
        if ((userTenants = this.getBindUsers(tenantId)).size() > 0) {
            filterParam = filterParam + "Q_id_N_NOTIN=" + StrUtil.join((CharSequence)",", (Iterable)userTenants.stream().map(f -> f.getUserid()).collect(Collectors.toList())) + ";";
        }
        return this.unityUserService.queryPage(filterParam, page, size, false);
    }

    @Override
    public void bindUsers(String userIds, String tenantId, Integer isAdmin) {
        ArrayList<SysUserTenant> toAdd = new ArrayList<SysUserTenant>();
        for (String userId : userIds.split(",")) {
            int exist = this.count((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysUserTenant.class).eq(SysUserTenant::getUserid, (Object)userId)).eq(SysUserTenant::getTenantid, (Object)tenantId));
            if (exist > 0) {
                throw new RuntimeException("\u5f53\u524d\u7528\u6237\u5df2\u5b58\u5728\uff01");
            }
            if (isAdmin == 1) {
                SysUserCatalog sysUserCatalog = new SysUserCatalog();
                sysUserCatalog.setUserCatalog(RoleLevelEnum.tenantAdmin.getValue());
                sysUserCatalog.setUserid(userId);
                this.sysUserCatalogService.saveOrUp(sysUserCatalog);
                this.bindDefaultRole(tenantId, userId);
            }
            toAdd.add(SysUserTenant.builder().tenantid(tenantId).userid(userId).isAdmin(isAdmin).build());
        }
        this.saveBatch(toAdd);
    }

    private void bindDefaultRole(String tenantId, String userId) {
        try {
            SysTenant sysTenant = (SysTenant)this.sysTenantMapper.selectById((Serializable)((Object)tenantId));
            if (StrUtil.isBlank((CharSequence)sysTenant.getDefaultRoleId())) {
                SysRole groupRole = new SysRole();
                groupRole.setTenantid(tenantId);
                groupRole.setLevel(1);
                groupRole.setName(TENANT_ADMIN_ROLE_GROUP_NAME);
                groupRole.setType(0);
                groupRole.setKey(TENANT_ADMIN_ROLE_GROUP_NAME);
                this.sysRoleService.saveOrUp(groupRole);
                SysRole sysRole = new SysRole();
                sysRole.setTenantid(tenantId);
                sysRole.setLevel(2);
                sysRole.setName(TENANT_ADMIN_ROLE_NAME);
                sysRole.setType(1);
                sysRole.setPid(groupRole.getId());
                sysRole.setKey(TENANT_ADMIN_ROLE_NAME);
                this.sysRoleService.saveOrUp(sysRole);
                List<SysSystem> sysSystems = this.sysTenantSystemService.queryBindSystems(tenantId);
                this.sysRoleSystemService.saveRoleSystems(sysRole.getId(), sysSystems.stream().map(f -> f.getId()).collect(Collectors.toList()), true);
                for (SysSystem sysSystem : sysSystems) {
                    List<SysTenantMenu> sysTenantMenus = this.sysTenantMenuService.queryBindMenus(tenantId, sysSystem.getId());
                    this.sysRoleMenuService.saveRoleMenus(sysRole.getId(), sysSystem.getId(), sysTenantMenus.stream().map(f -> f.getMenuid()).collect(Collectors.toList()));
                }
                sysTenant.setDefaultRoleId(sysRole.getId());
                this.sysTenantMapper.updateById(sysTenant);
            }
            this.sysUserRoleService.bindUsers(sysTenant.getDefaultRoleId(), Collections.singletonList(userId));
        }
        catch (Exception e) {
            throw new ServiceException(e.getMessage(), (Throwable)e);
        }
    }

    private void removeDefaultRole(String tenantId, String userId) {
        SysTenant sysTenant = (SysTenant)this.sysTenantMapper.selectById((Serializable)((Object)tenantId));
        if (StrUtil.isBlank((CharSequence)sysTenant.getDefaultRoleId())) {
            return;
        }
        this.sysUserRoleService.removeBindUsers(sysTenant.getDefaultRoleId(), Collections.singletonList(userId));
    }
}

