/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.util;

import cn.hutool.core.util.StrUtil;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.base.support.encryption.AESUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class PhoneNumberUtil {
    @Value(value="${userTel.encrypt:true}")
    private boolean userTelEncrypt;

    public boolean isTelEncrypt() {
        return this.userTelEncrypt;
    }

    public String getHidePhoneNumber(String realPhoneNumber) {
        if (StrUtil.isBlank((CharSequence)realPhoneNumber) || realPhoneNumber.length() < 11) {
            return realPhoneNumber;
        }
        return realPhoneNumber.substring(0, 3) + "****" + realPhoneNumber.substring(7, 11);
    }

    public String getEncryptPhoneNumber(String realPhoneNumber) {
        try {
            if (StrUtil.isBlank((CharSequence)realPhoneNumber)) {
                return "";
            }
            return AESUtils.encrypt((String)realPhoneNumber, (String)"FWAijk4A2Dwt2MKw");
        }
        catch (Exception exception) {
            throw new ServiceException(exception.getMessage(), (Throwable)exception);
        }
    }

    public String getDecryptPhoneNumber(String encryptPhoneNumber) {
        try {
            String tel = AESUtils.decrypt((String)encryptPhoneNumber, (String)"FWAijk4A2Dwt2MKw");
            return tel;
        }
        catch (Exception exception) {
            throw new ServiceException(exception.getMessage(), (Throwable)exception);
        }
    }

    public String convertPhoneNumberFilterParam(String filterParam) throws Exception {
        if (StrUtil.isBlank((CharSequence)filterParam)) {
            return filterParam;
        }
        String telStr = "tel_EQ_";
        String telEncryptStr = "telEncrypt_EQ_";
        if (!filterParam.contains(telStr)) {
            return filterParam;
        }
        int index = filterParam.indexOf(telStr);
        String sub1 = filterParam.substring(index);
        int i1 = sub1.indexOf(";");
        int i2 = sub1.indexOf(")");
        String sub2 = sub1;
        if (i1 > 0 || i2 > 0) {
            sub2 = i1 > 0 && i2 > 0 ? sub1.substring(0, Math.min(i1, i2)) : sub1.substring(0, Math.max(i1, i2));
        }
        String telValue = sub2.replace(telStr, "");
        String encryptValue = this.getEncryptPhoneNumber(telValue);
        return filterParam.replace(sub2, telEncryptStr + encryptValue);
    }
}

