package com.geoway.jckj.biz.config;

import com.geoway.jckj.base.enums.UserSysEnum;
import com.geoway.jckj.biz.entity.UserSync;
import com.geoway.jckj.biz.entity.UserSystem;
import com.geoway.jckj.biz.enums.SyncModeEnum;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;

/**
 * @author 连世忠
 * @ClassName UserSystemConfig
 * @Description TODO
 * @date 2025/7/8 14:31
 * @Version 1.0
 */
@ConfigurationProperties(prefix = "sso")
@Data
@Component
public class UserSystemConfig {
    @PostConstruct
    protected void init(){
        if(userSystem!=null&&userSystem.size()>0){
            return;
        }
        userSystem=new ArrayList<>();
        UserSystem tempSystem=new UserSystem();
        tempSystem.setCode(UserSysEnum.JCKJ.value);
        tempSystem.setName(UserSysEnum.JCKJ.name);
        tempSystem.setSync(new UserSync());
        tempSystem.getSync().setMode(SyncModeEnum.NO_SYNC.getValue());
        tempSystem.getSync().setEnable(true);
        userSystem.add(tempSystem);
    }
    private List<UserSystem> userSystem;
}
