package com.geoway.jckj.biz.entity;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.baomidou.mybatisplus.annotation.*;
import com.geoway.jckj.base.enums.UserSysEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @TableName sys_user
 */
@TableName(value = "sys_user")
@Data
public class SysUser extends SaasEntity implements Serializable {
    public SysUser(){
        this.source= UserSysEnum.JCKJ.value;
        this.catalog=3;
    }
    /**
     *
     */
    @TableId(value = "f_id", type = IdType.ASSIGN_ID)
    private String id;

    /**
     *
     */
    @Excel(name = "姓名(必填)", orderNum = "0")
    @TableField(value = "f_aname")
    private String aname;

    /**
     *
     */
    @Excel(name = "账户名(必填)", orderNum = "1")
    @TableField(value = "f_name")
    private String name;

//    @Excel(name = "密码(默认123456)", orderNum = "3")
    @TableField(exist = false)
    private String password;

    /**
     *
     */
    @Excel(name = "手机(必填)", orderNum = "4")
    @TableField(value = "f_tel")
    private String tel;

    /**
     * 加密的手机号
     */
    @TableField(value = "f_tel_encrypt")
    private String telEncrypt;

    /**
     * 用户级别（1. 超级管理员  2.普通管理员 3.普通用户）
     */
    @TableField(exist = false)
    private Integer catalog;


    /**
     *
     */
    @Excel(name = "电话", orderNum = "5")
    @TableField(value = "f_worktel")
    private String worktel;


    /**
     *
     */
    @Excel(name = "邮箱", orderNum = "6")
    @TableField(value = "f_email")
    private String email;

    /**
     *
     */
    @Excel(name = "身份证", orderNum = "7")
    @TableField(value = "f_bh")
    private String bh;

    /**
     *
     */
    @TableField(value = "f_zhiwu")
    private String zhiwu;

    /**
     *
     */
    @TableField(value = "f_ganwei")
    private String ganwei;

    /**
     *
     */
    @TableField(value = "f_zhiji")
    private String zhiji;

    /**
     *
     */
    @TableField(value = "f_zhicheng")
    private String zhicheng;

    /**
     *
     */
    @Excel(name = "性别", orderNum = "8", replace = {"男_0", "_null", "女_1"})
    @TableField(value = "f_sex")
    private int sex;

    /**
     *
     */
    @TableField(value = "f_worktype")
    private String worktype;


    /**
     *
     */
    @Excel(name = "地址", orderNum = "9")
    @TableField(value = "f_address")
    private String address;

    /**
     *
     */
    @TableField(value = "f_status")
    private Short status;



    /**
     *
     */
    @TableField(value = "f_createtime", fill = FieldFill.INSERT)
    private Date createtime;

    /**
     *
     */
    @TableField(value = "f_updatetime", fill = FieldFill.UPDATE)
    private Date updatetime;

    /**
     *
     */
    @TableField(value = "f_params")
    private String params;

    @TableField(value = "f_kind")
    private Integer kind;

    /**
     * 用户来源
     */
    //@Excel(name = "用户来源", orderNum = "10")
    @TableField(value = "f_source")
    private String source=UserSysEnum.JCKJ.value;

    @TableField(value = "f_imgid")
    private String imgid;

    @TableField("f_certificate_code")
    private String certificateCode;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

    @TableField(exist = false)
    private List<String> roleNames;

    @TableField(exist = false)
    private List<String> orgNames;

    @TableField(exist = false)
    private List<SysRegion> regions;
    @TableField(exist = false)
    private List<SysRole> roles;
    @TableField(exist = false)
    private List<SysOrganization> organizations;

    @TableField(exist = false)
    private String otherParams;
    @TableField(exist = false)
    private String resetPassword;
}