package com.geoway.jckj.biz.service.server;

import com.geoway.jckj.base.support.encryption.AESUtils;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.service.oauth2.IOauth2Service;
import com.geoway.jckj.biz.util.SysUserUtil;
import com.geoway.sso.client.enums.GrantTypeEnum;
import com.geoway.sso.client.enums.RoleLevelEnum;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.service.IOauth2Utils;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

/**
 * @author 连世忠
 * @ClassName IOauth2UtilsImpl
 * @Description TODO
 * @date 2025/5/20 15:42
 * @Version 1.0
 */
@Component
//@ConditionalOnExpression("#{T(com.geoway.sso.client.constant.SystemConstant).IS_SERVER}")
//@ConditionalOnExpression("!'${sso.server.url:}'.isEmpty()")
public class ServerOauth2UtilsImpl implements IOauth2Utils {
    @Autowired
    private IOauth2Service oauth2Service;
    @Override
    public Result<RpcAccessToken> getAccessToken(String serverUrl, String appId, String appSecret, String username, String password) {
        RpcAccessToken rpcAccessToken=oauth2Service.getAccessToken(GrantTypeEnum.PASSWORD.getValue(),appId,appSecret,"",username,password,"","","");
        return Result.createSuccess(rpcAccessToken);
    }

    @Override
    public Result<RpcAccessToken> getAccessToken(String serverUrl, String appId, String appSecret, String username, String password, String uuid, String code) {
        RpcAccessToken rpcAccessToken=oauth2Service.getAccessToken(GrantTypeEnum.PASSWORD_CAPTCHA.getValue(),appId,appSecret,"",username,password,"",uuid,code);
        return Result.createSuccess(rpcAccessToken);
    }

    @Override
    public Result<RpcAccessToken> getAccessTokenBySms(String serverUrl, String appId, String appSecret, String tel, String uuid, String code) {
        RpcAccessToken rpcAccessToken=oauth2Service.getAccessToken(GrantTypeEnum.TEL_CAPTCHA.getValue(),appId,appSecret,"","","",tel,uuid,code);
        return Result.createSuccess(rpcAccessToken);
    }

    @Override
    public Result<RpcAccessToken> getAccessTokenByOne(String serverUrl, String appId, String appSecret, String processId, String token, String authCode) {
        RpcAccessToken rpcAccessToken=oauth2Service.getAccessToken(GrantTypeEnum.ONE.getValue(),appId,appSecret,"","","","","","","","",processId,token,authCode);
        return Result.createSuccess(rpcAccessToken);
    }

    @Override
    public Result<RpcAccessToken> getAccessTokenByCa(String serverUrl, String appId, String appSecret, String caUserCert, String caOauthName) {
        RpcAccessToken rpcAccessToken=oauth2Service.getAccessToken(GrantTypeEnum.CA.getValue(),appId,appSecret,"","","","","","",caUserCert,caOauthName,"","","");
        return Result.createSuccess(rpcAccessToken);
    }

    @Override
    public Result<RpcAccessToken> getAccessTokenByCode(String serverUrl, String appId, String appSecret, String code) {
        RpcAccessToken rpcAccessToken=oauth2Service.getAccessToken(GrantTypeEnum.AUTHORIZATION_CODE.getValue(),appId,appSecret,code,"","","","","");
        if(rpcAccessToken==null){
            return Result.createError("获取token失败");
        }
        return Result.createSuccess(rpcAccessToken);
    }

    @Override
    public Result<RpcAccessToken> refreshToken(String serverUrl, String appId, String refreshToken) {
        //游客登入
        if(validateGuestToken(refreshToken)){
            return Result.createSuccess(getGuestRpcAccessToken(refreshToken));
        }
        RpcAccessToken rpcAccessToken=oauth2Service.refreshToken(appId,refreshToken);
        if(rpcAccessToken==null){
            return Result.createError("刷新token失败");
        }
        return Result.createSuccess(rpcAccessToken);
    }

    @Override
    public Result<RpcAccessToken> queryAccessToken(String serverUrl, String accessToken) {
        //游客登入
        if(validateGuestToken(accessToken)){
            return Result.createSuccess(getGuestRpcAccessToken(accessToken));
        }
        RpcAccessToken rpcAccessToken=oauth2Service.queryAccessToken(accessToken);
        if(rpcAccessToken!=null){
            return Result.createSuccess(rpcAccessToken);
        }
        return Result.createError("获取token失败");

    }

    @Override
    public Result<RpcAccessToken> revokeAccessToken(String serverUrl, String accessToken) {
        oauth2Service.revokeAccessToken(accessToken);
        return Result.createSuccess();
    }

    /**
     * 校验游客token
     * @param token
     * @return
     */
    private boolean validateGuestToken(String token) {
        String tokenPrefix="Geoway";
        if (!token.startsWith(tokenPrefix)) {
            return false;
        }
        // 提取加密部分
        String encryptedPart = token.substring(tokenPrefix.length());
        try {
            // AES解密
            String decryptedStr = AESUtils.decrypt(encryptedPart,AESUtils.KEY);
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            String formattedDate = LocalDate.now().format(formatter);
            // 验证是否为日期格式(简单版)
            return formattedDate.equalsIgnoreCase(decryptedStr);
        } catch (Exception e) {
            return false;
        }
    }

    private RpcAccessToken getGuestRpcAccessToken(String token){
        SysUser sysUser = SysUserUtil.getGuestUser();
        SsoUser ssoUser =SysUserUtil.convertToSsoUser(sysUser);
        ssoUser.setToken(token);
        ssoUser.setUserCatalog(RoleLevelEnum.guset.getValue());
        RpcAccessToken rpcAccessToken = new RpcAccessToken(ssoUser.getToken(), 60,ssoUser.getToken(), ssoUser);
        return rpcAccessToken;
    }

}
