package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.base.support.encryption.AESUtils;
import com.geoway.jckj.base.support.query.MPJQueryMapperUtil;
import com.geoway.jckj.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.jckj.biz.config.TenantConfig;
import com.geoway.jckj.biz.enums.TenantUserRangeEnum;
import com.geoway.jckj.biz.util.TenantUtil;
import com.geoway.sso.client.enums.RoleLevelEnum;
import com.geoway.jckj.biz.dto.UserRelParams;
import com.geoway.jckj.biz.entity.*;
import com.geoway.jckj.biz.mapper.SysUserRegisterMapper;
import com.geoway.jckj.biz.service.dev.unity.IUnityOrganizationService;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserService;
import com.geoway.jckj.biz.service.sys.*;
import com.geoway.jckj.biz.util.PhoneNumberUtil;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author wangqiang
 * @description 针对表【sys_user_register】的数据库操作Service实现
 * @createDate 2024-07-03 16:40:13
 */
@Service
public class SysUserRegisterServiceImpl extends ServiceImpl<SysUserRegisterMapper, SysUserRegister>
        implements SysUserRegisterService {
    @Resource
    private IUnityUserService sysUserService;
    @Resource
    private IUnityOrganizationService organizationService;
    @Resource
    private SysRegionService sysRegionService;
    @Resource
    private SysUserRoleService sysUserRoleService;
    @Value("${userRegister.auditMode:2}")
    private int auditMode;
    @Resource
    private PhoneNumberUtil phoneNumberUtil;
    @Resource
    private TenantConfig projectConfig;
    @Override
    public Boolean checkAccoutRepeat(String accout) throws Exception {
        List<SysUser> users = sysUserService.queryList("name_EQ_" + accout);
        // auditState=2 审核不通过可以继续注册
        List<SysUserRegister> usersRegister = this.queryList("name_EQ_" + accout + ";auditState_NE_2");
        return users.size() > 0 || usersRegister.size() > 0;
    }

    @Override
    public Boolean checkTelRepeat(String tel) throws Exception {
        List<SysUser> users = sysUserService.queryList("tel_EQ_" + tel);
        List<SysUserRegister> usersRegister = this.queryList("tel_EQ_" + tel + ";auditState_NE_2");
        return users.size() > 0 || usersRegister.size() > 0;
    }

    @Override
    public Boolean registerUser(SysUserRegister sysUserRegister) {
        String tel = sysUserRegister.getTel();
        if (StringUtils.isBlank(tel)) {
            throw new ServiceException("手机号不能为空");
        }
        if (tel.length() != 11) {
            throw new RuntimeException("手机号格式错误");
        }
        // 手机号加密
        try {
            sysUserRegister.setTelEncrypt(AESUtils.encrypt(tel, AESUtils.KEY));
        } catch (Exception e) {
            e.printStackTrace();
        }
        // 手机号隐藏中间4位
        sysUserRegister.setTel(tel.substring(0, 3) + "****" + tel.substring(7, 11));

        this.save(sysUserRegister);

        return true;
    }

    @Override
    public IPage<SysUserRegister> queryPage(String filterParam, int page, int size) throws Exception {
        Page<SysUserRegister> pages = new Page<>(page, size);
        if(phoneNumberUtil.isTelEncrypt()) {
            filterParam = phoneNumberUtil.convertPhoneNumberFilterParam(filterParam);
        }
        Integer userCatalog= CommonLoginUserUtil.getUser().getUserCatalog();
        MPJQueryMapperUtil mpjQueryMapperUtil = new MPJQueryMapperUtil();
        MPJLambdaWrapper<SysUserRegister> queryWrapper = mpjQueryMapperUtil.queryMapper(filterParam,SysUserRegister.class);
        if (userCatalog == null || userCatalog>RoleLevelEnum.tenantAdmin.getValue()) {
            return pages;
        }
        if (userCatalog == RoleLevelEnum.tenantAdmin.getValue()) {
            TenantUserRangeEnum userRangeEnum=TenantUserRangeEnum.getEnumByValue(projectConfig.getTenantUserRange());
            List<String> regions=TenantUtil.getTenantRegionIds();
            List<String> orgs=TenantUtil.getTenantOrgIds();
            if(userRangeEnum==TenantUserRangeEnum.REGION&&regions.size()==0){
                return pages;
            }
            if(userRangeEnum==TenantUserRangeEnum.ORG&&orgs.size()==0){
                return pages;
            }
            if(userRangeEnum==TenantUserRangeEnum.REGION_ORG&&orgs.size()==0&&regions.size()==0){
                return pages;
            }
            queryWrapper.and(wrapper-> {
                if(regions.size()>0) {
                    wrapper.in(SysUserRegister::getRegion, regions);
                }
                if(orgs.size()>0){
                    wrapper.or().in(SysUserRegister::getOrganization,orgs);
                }
            });
        }
        queryWrapper.orderByAsc("f_createtime");
        IPage<SysUserRegister> pageUsers = this.baseMapper.selectPage(pages, queryWrapper);
        for (SysUserRegister register : pageUsers.getRecords()) {
            // 查找组织全路径
            if (StringUtils.isNotBlank(register.getOrganization())) {
               SysOrganization organization = organizationService.findOneById(register.getOrganization(),"");
               organization.setAllname(StrUtil.join("/", organizationService.queryAllParentOrg(organization.getId())
                        .stream().map(SysOrganization::getName).collect(Collectors.toList())));
                register.setOrgNames(organization.getAllname());
            }

            // 查找辖区全路径
            if (StringUtils.isNotBlank(register.getRegion())) {
                SysRegion sysRegion=sysRegionService.getById(register.getRegion());
                sysRegion.setAllname(StrUtil.join("/", sysRegionService.queryAllParentRegionById(sysRegion.getId())
                        .stream().map(SysRegion::getName).collect(Collectors.toList())));
                register.setRegionNames(sysRegion.getAllname());
            }

            if (StringUtils.isNotBlank(register.getAuditUser())) {
                register.setAuditUserName(sysUserService.query(register.getAuditUser()).getName());
            }
        }

        return pageUsers;
    }

    @Override
    public List<SysUserRegister> queryList(String filterParam) throws Exception {
        if(phoneNumberUtil.isTelEncrypt()){
            filterParam=phoneNumberUtil.convertPhoneNumberFilterParam(filterParam);
        }
        MyBatisQueryMapperUtils<SysUserRegister> qmu = new MyBatisQueryMapperUtils<>();
        QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysUserRegister.class);
        queryWrapper.orderByAsc("f_createtime");

        List<SysUserRegister> users = this.baseMapper.selectList(queryWrapper);
        return users;
    }

    @Override
    public Boolean audit(String userId, String id, Boolean passed, String auditOpinion, String roleIds) throws Exception {
        if (StringUtils.isBlank(userId)) {
            return false;
        }
        SysUserRegister entity = this.getById(id);
        if (entity == null) {
            return false;
        }
        entity.setAuditState(Boolean.TRUE.equals(passed) ? "1" : "2");
        entity.setAuditOpinion(auditOpinion);
        entity.setAuditTime(new Date());
        entity.setAuditUser(userId);
        this.updateById(entity);

        // 审核通过时添加到用户表
        if ("1".equals(entity.getAuditState())) {
            SysUser sysUser = new SysUser();
            BeanUtil.copyProperties(entity, sysUser, true);
            sysUser.setId(null);
            sysUser.setCatalog(RoleLevelEnum.commonUser.getValue()); // 普通用户

            if (entity.getKind() == 1) {
                UserRelParams userRelParams = new UserRelParams();
                if (StrUtil.isNotBlank(entity.getOrganization())) {
                    userRelParams.setOrganizations(Arrays.asList(entity.getOrganization().split(",")));
                }
                userRelParams.setRegions(Arrays.asList(entity.getRegion()));
                sysUser.setOtherParams(JSON.toJSONString(userRelParams));
            }

            sysUserService.saveOrUp(sysUser, null, false);

            // 保存用户角色
            if (StrUtil.isNotBlank(roleIds)) {
                sysUserRoleService.updateUserRole(sysUser.getId(), Arrays.asList(roleIds.split(",")));
            }
        }

        return true;
    }
}




