package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.jckj.base.config.SsoConfigProp;
import com.geoway.jckj.base.enums.UserSysEnum;
import com.geoway.jckj.base.support.BaseTreeUtil;
import com.geoway.jckj.base.support.StringUtils;
import com.geoway.jckj.base.support.query.MPJQueryMapperUtil;
import com.geoway.jckj.biz.dto.AppMenuDTO;
import com.geoway.jckj.biz.dto.SystemInfoDTO;
import com.geoway.jckj.biz.dto.UserSysDTO;
import com.geoway.jckj.biz.entity.*;
import com.geoway.jckj.biz.exception.BizException;
import com.geoway.jckj.biz.mapper.*;
import com.geoway.jckj.biz.service.ISaasEntityService;
import com.geoway.jckj.biz.service.dev.unity.IUnityMenuUrlHandlerService;
import com.geoway.jckj.biz.service.sys.SysUserTenantService;
import com.geoway.jckj.biz.service.sys.*;
import com.geoway.jckj.biz.util.SaasEntityUtil;
import com.geoway.jckj.biz.util.SysSystemUtil;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 系统
 *
 * @author: wujing
 * @Date: 2021/11/15
 */
@Service
public class SystemServiceImpl extends MPJBaseServiceImpl<SysSystemMapper, SysSystem>
        implements SystemService, ISaasEntityService<SysSystem> {

    @Autowired
    private SysSystemMapper sysSystemMapper;

    @Autowired
    private SysMenuMapper menuMapper;

    @Autowired
    private SysMenuServiceImpl menuService;

    @Autowired
    private SysThemeService sysThemeService;

    @Autowired
    SysImageService sysImageService;

    @Autowired
    SysGroupService sysGroupService;

    @Autowired
    SysRoleService sysRoleService;

    @Autowired
    SysRoleSystemMapper sysRoleSystemMapper;

    @Autowired
    private SsoConfigProp ssoConfig;

    @Autowired
    SysTenantSystemService sysTenantSystemService;

    @Autowired
    SysUserTenantService sysUserTenantService;
    @Autowired
    SysRoleMenuService sysRoleMenuService;
    @Autowired
    SysRoleSystemService sysRoleSystemService;
    @Autowired
    IUnityMenuUrlHandlerService menuUrlHandlerService;
    @Override
    public void saveOrUp(SysSystem sysNsSystem, MultipartFile logofile, MultipartFile bgfile) throws Exception{
        if (StringUtils.isEmpty(sysNsSystem.getKey())) {
            throw new Exception("【关键字】不能为空！");
        } else {
            LambdaQueryWrapper<SysSystem> wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysSystem::getKey, sysNsSystem.getKey());
            //有id的时候是编辑，不查询本身
            if (StringUtils.isNotEmpty(sysNsSystem.getId())) {
                wrapper.ne(SysSystem::getId, sysNsSystem.getId());
            }
            SysSystem one = this.getOne(wrapper);
            if (one != null) {
                throw new Exception("关键字【" + one.getKey() + "】已存在！");
            }
        }

        SysSystem exsitSystem=getById(sysNsSystem.getId());
        if(exsitSystem == null){
            wrapperEntity(sysNsSystem);
        }
        //保存图片信息
        if(logofile != null && !logofile.isEmpty()){

            SysImage sysImage = sysImageService.getById(sysNsSystem.getLogoid());
            if(sysImage == null ){
                sysImage = new SysImage();
                sysImage.setObjectid(sysNsSystem.getId());
                sysImage.setType(1);
            }

            sysImage.setImage(logofile.getBytes());
            sysImageService.saveOrUpdate(sysImage);
            sysNsSystem.setLogoid(sysImage.getId());
        }

        if(bgfile != null && !bgfile.isEmpty()){

            SysImage sysImage = sysImageService.getById(sysNsSystem.getBgid());
            if(sysImage == null ){
                sysImage = new SysImage();
                sysImage.setObjectid(sysNsSystem.getId());
                sysImage.setType(1);
            }

            sysImage.setImage(bgfile.getBytes());
            sysImageService.saveOrUpdate(sysImage);
            sysNsSystem.setBgid(sysImage.getId());
        }
         //新建或者是编辑自己租户空间下创建的应用
        if(exsitSystem==null||exsitSystem.getTenantid().equals(getTenantId())){
            //保存
            this.saveOrUpdate(sysNsSystem);
        }else{
            //编辑管理员授权的系统
            sysTenantSystemService.saveSystem(getTenantId(),sysNsSystem);
        }

    }

    @Override
    public void deleteSystem(String id) throws Exception {

        SysSystem sysNsSystem = this.getById(id);
        //删除应用关联的图片资源
//        if(sysNsSystem !=null && StrUtil.isNotBlank(sysNsSystem.getLogoid())){
//            sysImageService.removeById(sysNsSystem.getLogoid());
//        }
//        if(sysNsSystem !=null && StrUtil.isNotBlank(sysNsSystem.getBgid())){
//            sysImageService.removeById(sysNsSystem.getBgid());
//        }
        //删除应用
        this.removeById(id);
        //级联删除菜单
        LambdaQueryWrapper<SysMenu> menuWrapper = Wrappers.lambdaQuery();
        menuWrapper.eq(SysMenu::getSystemId, sysNsSystem.getId());
        menuMapper.delete(menuWrapper);

        //删除应用关联的权限信息
        LambdaQueryWrapper<SysRoleSystem> queryWrapper2 = Wrappers.lambdaQuery();
        queryWrapper2.eq(SysRoleSystem::getSystemid, sysNsSystem.getId());
        sysRoleSystemMapper.delete(queryWrapper2);


    }

    @Override
    public void deleteSystems(String ids) throws Exception {
        if(StrUtil.isBlank(ids)){
            return;
        }
        String[] idArr = ids.split(",");
        for(String id: idArr){
            this.deleteSystem(id);
        }
    }

    @Override
    public SystemInfoDTO queryInfo(String key) {
        SystemInfoDTO systemInfoDTO = new SystemInfoDTO();
        if (StringUtils.isNotEmpty(key)) {
            //查询系统信息
            LambdaQueryWrapper<SysSystem> wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysSystem::getKey, key);
            SysSystem sysNsSystem = this.getOne(wrapper);
            SysSystemUtil.wrapper(Collections.singletonList(sysNsSystem));
            if (sysNsSystem != null) {
                //菜单信息
                List<SysMenu> sysMenus = menuService.queryMenuTree(sysNsSystem.getId(),0);
                List<SysMenu> uCenterMenu = menuService.queryMenuTree(sysNsSystem.getId(), 1);
                //
                systemInfoDTO.setSystem(sysNsSystem);
                systemInfoDTO.setMenu(sysMenus);
                systemInfoDTO.setUCenterMenu(uCenterMenu);

            }
        }
        return systemInfoDTO;
    }

    @Override
    public List<SysSystem> queryList() throws Exception {

        MPJLambdaWrapper<SysSystem> queryWrapper = buildLambdaWrapper("","");
        List<SysSystem> systems = this.list(queryWrapper);
        SysSystemUtil.wrapper(systems);
        return CollUtil.distinct(systems);
    }


    @Override
    public List<SysSystem> queryListNotInRole(String roleId) throws Exception {
        MPJLambdaWrapper<SysSystem> queryWrapper = buildLambdaWrapper("","");
        if(StrUtil.isNotBlank(roleId)){
            LambdaQueryWrapper<SysRoleSystem> queryWrapper2 =  Wrappers.lambdaQuery();
            queryWrapper2.eq(SysRoleSystem::getRoleid,roleId);
            List<SysRoleSystem> sysRoleSystems = sysRoleSystemMapper.selectList(queryWrapper2);
            if(sysRoleSystems != null && sysRoleSystems.size() > 0){
                List<String> systemIds = sysRoleSystems.stream().map( item -> item.getSystemid()).collect(Collectors.toList());
                queryWrapper.notIn(SysSystem::getId,systemIds);
            }
        }
        List<SysSystem> result=this.list(queryWrapper);
        SysSystemUtil.wrapper(result);
        return result;
    }



    @Override
    public List<SysSystem> queryAll() {
        LambdaQueryWrapper<SysSystem> wrapper = Wrappers.lambdaQuery();
        wrapper.orderByDesc(SysSystem::getCreatetime);
        List<SysSystem> list = this.list(wrapper);
        for (SysSystem sysNsSystem : list) {
            //0:菜单树 1:个人中心
            List<SysMenu> sysMenus = menuService.queryMenuTree(sysNsSystem.getId(), 0);
            List<SysMenu> userMenus = menuService.queryMenuTree(sysNsSystem.getId(), 1);
            sysNsSystem.setSysMenu(sysMenus);
            sysNsSystem.setUCenterMenu(userMenus);
        }
        SysSystemUtil.wrapper(list);
        return list;
    }

    @Override
    public void stateUp(String id, Integer state) {
        LambdaUpdateWrapper<SysSystem> update = Wrappers.lambdaUpdate();
        update.eq(SysSystem::getId, id);
        update.set(SysSystem::getState, state);

        this.update(update);
    }

    @Override
    public List<SysGroup> queryGroupSystems() throws Exception {

        List<SysSystem> systems=queryList();
        List<String> groupIds=systems.stream().map(f->f.getGroupid()).collect(Collectors.toList());
        MPJLambdaWrapper<SysGroup> groupWrapper =sysGroupService.buildLambdaWrapper("","");
        if(groupIds.size()>0) {
            groupWrapper.or().in(SysGroup::getId, groupIds);
        }
        List<SysGroup> groups = sysGroupService.list(groupWrapper);
        SaasEntityUtil.wrapper(groups);
        for(SysGroup group:groups){
            group.setSystems(systems.stream().filter(f->f.getGroupid().equals(group.getId())).collect(Collectors.toList()));
        }
        return groups;
    }


    @Override
    public SystemInfoDTO querySystemInfoByUser(String systemKey) {

        SystemInfoDTO  systemInfoDTO = new SystemInfoDTO();
        if (StringUtils.isNotEmpty(systemKey)) {
            //查询系统信息
            LambdaQueryWrapper<SysSystem> wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysSystem::getKey, systemKey);
            wrapper.last(" limit 1");
            SysSystem  systemOne = this.getOne(wrapper);
            if(systemOne==null){
                return systemInfoDTO;
            }
            SysSystemUtil.wrapper(Collections.singletonList(systemOne));
            if ( systemOne != null) {
                //菜单信息
                SysTheme themeOne = sysThemeService.findOne(systemOne.getThemeid());
                List<SysMenu> sysMenus = menuService.queryUserMenuTree(systemOne.getId(), 0);
                handlerMenuUrl(systemOne,themeOne,sysMenus);
                List<SysMenu> uCenterMenu = menuService.queryUserMenuTree(systemOne.getId(), 1);
                handlerMenuUrl(systemOne,themeOne,uCenterMenu);
                //
                systemInfoDTO.setSystem(systemOne);
                systemInfoDTO.setTheme(themeOne);
                systemInfoDTO.setMenu(sysMenus);
                systemInfoDTO.setUCenterMenu(uCenterMenu);
            }
        }
        return systemInfoDTO;
    }

    private void handlerMenuUrl(SysSystem sysSystem, SysTheme sysTheme, List<SysMenu> sysMenus){
        if(sysMenus==null){
            return;
        }
        sysMenus.forEach(f->{
            menuUrlHandlerService.handler(sysSystem,sysTheme,f);
            handlerMenuUrl(sysSystem,sysTheme,f.getChildren());
        });

    }

    @Override
    public List<SysSystem> querySystemListByUser(String userId) {
        if(StrUtil.isBlank(userId)) {
            userId=getQueryUserId();
        }
        if(StrUtil.isBlank(userId)) {
            return null;
        }
        List<SysRole> sysRoles= sysRoleService.queryUserRoles(userId);
        if(sysRoles.size()==0){
            return null;
        }
        //查找角色直接关联的系统
        MPJLambdaWrapper<SysSystem> joinWrapper = buildLambdaWrapper("","");
        joinWrapper.leftJoin(SysRoleSystem.class,SysRoleSystem::getSystemid, SysSystem::getId);
        joinWrapper.leftJoin(SysUserRole.class,SysUserRole::getRoleid,SysRoleSystem::getRoleid);
        joinWrapper.leftJoin(SysRole.class,SysRole::getId,SysRoleSystem::getRoleid);
        joinWrapper.eq(SysUserRole::getUserid,userId);
        joinWrapper.in(SysRole::getId,sysRoles.stream().map(f->f.getId()).collect(Collectors.toList()));
        List<SysSystem> roleSystems = sysSystemMapper.selectJoinList(SysSystem.class,joinWrapper);
        SysSystemUtil.wrapper(roleSystems);
        return CollUtil.distinct(roleSystems);
    }




    @Override
    public void saveGroup(SysGroup group) throws Exception {
        group.setType(1);
        LambdaQueryWrapper<SysGroup> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysGroup::getType,1);
        queryWrapper.eq(SysGroup::getName,group.getName());
        if(StrUtil.isBlank(group.getId())){
            int icount = sysGroupService.count(queryWrapper);
            if(icount > 0){
                throw  new BizException("分组名称: 【"+ group.getName() +"】 已存在");
            }
            sysGroupService.wrapperEntity(group);
            sysGroupService.save(group);
        }else{
            queryWrapper.ne(SysGroup::getId,group.getId());
            int icount =sysGroupService.count(queryWrapper);
            if(icount > 0){
                throw  new BizException("分组名称: 【"+ group.getName() +"】 已存在");
            }
            sysGroupService.updateById(group);
        }
    }

    @Override
    public void saveRoleSystem(String systemId, List<String> roleIds,List<String> menuIds){
        List<String> systemIds=new ArrayList<>();
        systemIds.add(systemId);
        List<SysRole> sysRoles=sysRoleSystemService.systemRelateRoles(systemId);
        for(String roleId:roleIds) {
            //之前已经有该系统权限的角色跳过
            if(sysRoles.stream().filter(f->f.getId().equals(roleId)).count()>0){
                continue;
            }
            sysRoleSystemService.saveRoleSystems(roleId,systemIds,false);
            sysRoleMenuService.saveRoleMenus(roleId,systemId,menuIds);
        }
        //移除掉旧的role
        for(SysRole sysRole:sysRoles){
            //
            if(roleIds.contains(sysRole.getId())){
                continue;
            }
            sysRoleSystemService.removeRoleSystem(sysRole.getId(),systemId);
        }
    }
    @Override
    public void deleteGroup(String groupId) throws Exception {
        LambdaQueryWrapper<SysSystem> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysSystem::getGroupid,groupId);
        int icount = this.count(queryWrapper);
        if(icount > 0){
            throw  new Exception("应用分组下有关联系统，不能删除");
        }
        sysGroupService.removeById(groupId);
    }

    @Override
    public List<AppMenuDTO> queryAppMenus(String key) throws Exception {
        SysSystem system = querySystemByKey(key);
        if(system == null){
            throw  new Exception("系统不存在");
        }
        String systemId = system.getId();
        List<SysMenu> menus = menuService.queryUserMenusList(systemId,0);
        List<AppMenuDTO> appMenuTress = this.convertToAppMenuTree(systemId,menus);
        return appMenuTress;
    }

    @Override
    public SysSystem querySystemByKey(String key) {

        LambdaQueryWrapper<SysSystem> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysSystem::getKey,key);
        queryWrapper.last(" limit 1");
        SysSystem sysSystem=this.getOne(queryWrapper);
        SysSystemUtil.wrapper(Collections.singletonList(sysSystem));
        return sysSystem;
    }




    private List<AppMenuDTO> convertToAppMenuTree(String systemId, List<SysMenu>  menus){
        final int  relPath = 1; //相对路径
        final int  absPath = 2; //绝对路径

        List<AppMenuDTO> appMenuDTOS = new ArrayList<>();
        for(SysMenu menu: menus){

            AppMenuDTO appMenuDTO = new AppMenuDTO();
            appMenuDTO.setName(menu.getName());
            appMenuDTO.setId(menu.getId());
            appMenuDTO.setKey(menu.getKey());
            appMenuDTO.setRoutename(menu.getKey());
            appMenuDTO.setPid(menu.getPid());
            appMenuDTO.setSystemId(systemId);

            appMenuDTO.setNoLogin(menu.getNologin());
            int linkType = 0;
            if(menu.getMenuPath() != null){
                linkType = menu.getMenuPath().getPathType() == relPath ? 0: 1;
                if(menu.getMenuPath().getPathType() == relPath){
                    appMenuDTO.setPath(menu.getPath());
                }else{
                    appMenuDTO.setPath(menu.getAbsPath());
                }

            }
            appMenuDTO.setLink(linkType);
            int newPage = menu.getOpenMode() == 3 ? 1: 0;
            appMenuDTO.setNewPage(newPage);
            appMenuDTO.setSort(menu.getSort());


            appMenuDTOS.add(appMenuDTO);
        }

        final String rootPid = "0";
        final TreeNodeConfig treeNodeConfig =
                new TreeNodeConfig().setParentIdKey("pid").setWeightKey("sort").setIdKey("id");

        List<AppMenuDTO> menuTrees = BaseTreeUtil.listToTree(appMenuDTOS, treeNodeConfig, rootPid);


        return  menuTrees;
    }

    @Override
    public MPJLambdaWrapper<SysSystem> buildLambdaWrapper(String filterParam, String sortParam) {

        try {
            if (filterParam == null) {
                filterParam = "";
            }
            if (sortParam == null) {
                sortParam = "";
            }
            MPJQueryMapperUtil<SysSystem> qmu = new MPJQueryMapperUtil<>();
            MPJLambdaWrapper<SysSystem> queryWrapper = qmu.queryMapper(filterParam, sortParam, getClassT());
            //queryWrapper.leftJoin(SysUser.class,SysUser::getId,SysSystem::getCreatorid);
            //查询系统管理员授予的系统
            List<SysSystem> bindSystems =  sysTenantSystemService.queryBindSystems(getTenantId());
            if(bindSystems.size()==0) {
                queryWrapper.and(wrapper -> wrapper.eq(SysSystem::getTenantid, getTenantId()));
            }else{
                queryWrapper.and(wrapper -> wrapper.eq(SysSystem::getTenantid, getTenantId()).or().in(SysSystem::getId,bindSystems.stream().map(g->g.getId()).collect(Collectors.toList())));
            }

            queryWrapper.selectAll(SysSystem.class);
            //queryWrapper.selectAs(SysUser::getAname,SysSystem::getCreatorname);
            queryWrapper.distinct();
            return queryWrapper;
        }catch (Exception exception){
            throw new RuntimeException(exception);
        }



    }
}
