package com.geoway.jckj.biz.util;

import com.geoway.jckj.base.support.spring.SpringUtils;
import com.geoway.jckj.biz.entity.*;
import com.geoway.jckj.biz.service.dev.unity.IUnityOrganizationService;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserService;
import com.geoway.jckj.biz.service.sys.*;
import com.geoway.sso.client.enums.RoleLevelEnum;
import com.geoway.sso.client.rpc.SsoUser;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author 连世忠
 * @ClassName SysUserUtil
 * @Description TODO
 * @date 2025/3/13 17:18
 * @Version 1.0
 */

public class SysUserUtil {
    public static void wrapperUsers(List<SysUser> users){
        wrapperUserRolesNames(users);
        wrapperUserOrgsNames(users);
        wrapperUserCatalogs(users);
        wrapperUserRegions(users);
    }

    public static void wrapperUserRolesNames(List<SysUser> users) {
        SysRoleService sysRoleService= SpringUtils.getBean(SysRoleService.class);
        for (SysUser user : users) {
            if(user==null){
                continue;
            }
            List<SysRole> roles = sysRoleService.queryUserRoles(user.getId());
            List<String> roleAllNames = roles.stream().map(x -> x.getName()).collect(Collectors.toList());
            user.setRoles(roles);
            user.setRoleNames(roleAllNames);
        }
    }

    public static void wrapperUserOrgsNames(List<SysUser> users) {
        IUnityOrganizationService organizationService=SpringUtils.getBean(IUnityOrganizationService.class);
        for (SysUser user : users) {
            if(user==null){
                continue;
            }
            List<SysOrganization> organizations = organizationService.queryUserOrgs(user.getId());
            List<String> organizationNames = organizations.stream().map(x -> x.getName()).collect(Collectors.toList());
            user.setOrganizations(organizations);
            user.setOrgNames(organizationNames);
        }
    }

    public static void wrapperUserCatalogs(List<SysUser> users){
        SysUserCatalogService userCatalogService=SpringUtils.getBean(SysUserCatalogService.class);
        for (SysUser user : users) {
            if(user==null){
                continue;
            }
            user.setCatalog(userCatalogService.getUserCatalog(user.getId()));
        }
    }

    public static void wrapperUserRegions(List<SysUser> users){
        SysRegionService userRegionService=SpringUtils.getBean(SysRegionService.class);
        for (SysUser user : users) {
            if(user==null){
                continue;
            }
            user.setRegions(userRegionService.queryUserRegions(user.getId()));
        }
    }

    public static  SsoUser convertToSsoUser(SysUser user){
        SsoUser ssoUser = new SsoUser();
        SysUserUtil.wrapperUsers(Collections.singletonList(user));
        SysRegionService sysRegionService=SpringUtils.getBean(SysRegionService.class);
        SysTenantService sysTenantService=SpringUtils.getBean(SysTenantService.class);
        SysRoleService sysRoleService=SpringUtils.getBean(SysRoleService.class);
        List<SysRegion> regions = sysRegionService.queryUserRegions(user.getId());
        String regionCode = regions.stream().map(i -> i.getCode()).collect(Collectors.joining(","));
        String regionName = regions.stream().map(i -> i.getName()).collect(Collectors.joining(","));
        if(user.getCatalog().equals(RoleLevelEnum.tenantAdmin.getValue())){
            List<SysTenant> sysTenants=sysTenantService.queryByUserId(user.getId());
            String tenant=sysTenants.stream().map(f->f.getId()).collect(Collectors.joining(","));
            ssoUser.setTenantIds(tenant);
        }
        ssoUser.setRoldIds(sysRoleService.queryUserRoles(user.getId()).stream().map(f->f.getId()).collect(Collectors.joining(",")));
        ssoUser.setId(user.getId());
        ssoUser.setUserid(user.getId());
        ssoUser.setUserName(user.getAname());
        ssoUser.setLoginName(user.getName());
        ssoUser.setRegionCode(regionCode);
        ssoUser.setRegionName(regionName);
        ssoUser.setUserCatalog(user.getCatalog());
        ssoUser.setSource(user.getSource());
        return ssoUser;
    }

    /**
     * 获取游客用户
     * @return
     */
    public static  SysUser  getGuestUser(){
        IUnityUserService unityUserService=SpringUtils.getBean(IUnityUserService.class);
        SysUser sysUser= unityUserService.getLocalService().query("guest");
        return sysUser;
    }
}
