package com.geoway.jckj.biz.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import lombok.Data;
import lombok.experimental.FieldNameConstants;

/**
 * 系统菜单路径
 * @TableName sys_menupath
 */
@TableName(value ="sys_menupath")
@Data
@FieldNameConstants
public class SysMenuPath implements Serializable {
    /**
     * 
     */
    @TableId(value = "f_id")
    private String id;

    /**
     * 菜单路径
     */
    @TableField(value = "f_path")
    private String path;

    /**
     * 路径类型（1.相对路径 2.绝对路径）
     */
    @TableField(value = "f_pathtype")
    private Integer pathType;

    /**
     * 原始的应用id
     */
    @TableField(value = "f_pid")
    private String pid;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}