package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.geoway.jckj.biz.dto.UserOnlineStatDTO;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.service.dev.unity.IUnityLoginService;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserService;
import com.geoway.jckj.biz.service.sys.SysUserOnlineService;
import com.geoway.jckj.biz.util.TenantUtil;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.server.session.AccessTokenManager;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author 连世忠
 * @ClassName SysUserOnlineServiceImpl
 * @Description TODO
 * @date 2025/4/29 15:39
 * @Version 1.0
 */
@Service
@Slf4j
public class SysUserOnlineServiceImpl implements SysUserOnlineService {
    @Autowired
    private IUnityUserService unityUserService;
    @Autowired
    private IUnityLoginService loginService;
    @Autowired
    private AccessTokenManager accessTokenManager;
    @Override
    public UserOnlineStatDTO getStatInfo() {
        UserOnlineStatDTO result = new UserOnlineStatDTO();
        int offline = 0;
        //获取所有用户
        int all =unityUserService.queryCount("");
        //获取在线用户
        List<SsoUser>  users=accessTokenManager.getOnlineUsers();
        //非管理员模式
        if(!TenantUtil.isSuperTenant()&&users.size()>0) {
            String filterParam="Q_id_N_IN="+StrUtil.join(",", users.stream().map(f->f.getId()).collect(Collectors.toList()))+";";
            List<SysUser> sysUsers = unityUserService.queryList(filterParam, false);
            users = users.stream().filter(f -> sysUsers.stream().anyMatch(g -> g.getId().equals(f.getId()))).
                    collect(Collectors.toList());
        }
        int online=users.size();
        offline = all - online;
        result.setAll(all);
        result.setOffline(offline);
        result.setOnline(online);
        result.setUsers(users);
        return result;
    }

    @Override
    public boolean isOnline(String userName, String password) {
        try {
            Result<SsoUser> loginResult = loginService.login(userName, password);
            if (loginResult == null) {
                return false;
            }
            if (!loginResult.isSuccess() || loginResult.getData() == null) {
                return false;
            }
            List<SsoUser> onlineUsers = accessTokenManager.getOnlineUsers(loginResult.getData().getUserid());
            return CollectionUtil.isNotEmpty(onlineUsers);
        }catch (Exception e){
             log.error(e.getMessage(),e);
             return false;
        }
    }
}
