package com.geoway.jckj.biz.util;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.base.support.encryption.AESUtils;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.sso.client.enums.RoleLevelEnum;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.rpc.SsoUser;

import java.util.Date;

/**
 * @author 连世忠
 * @ClassName GuestUtil
 * @Description TODO
 * @date 2025/7/29 11:44
 * @Version 1.0
 */
public class GuestUtil {


    public static String getGuestToken(){

        String token="Geoway";
        try {
            String formattedDate = DateUtil.format(new Date(), DatePattern.NORM_DATE_PATTERN);
            String encryptedPart = AESUtils.encrypt(formattedDate, AESUtils.KEY);
            token=token+encryptedPart;
        }catch (Exception e){
            throw new ServiceException("",e);
        }
        return token;
    }
    /**
     * 校验游客token
     * @param token
     * @return
     */
    public static boolean validateGuestToken(String token) {
        String tokenPrefix="Geoway";
        if (!token.startsWith(tokenPrefix)) {
            return false;
        }
        // 提取加密部分
        String encryptedPart = token.substring(tokenPrefix.length());
        try {
            // AES解密
            String decryptedStr = AESUtils.decrypt(encryptedPart,AESUtils.KEY);
            String formattedDate = DateUtil.format(new Date(), DatePattern.NORM_DATE_PATTERN);
            // 验证是否为日期格式(简单版)
            return formattedDate.equalsIgnoreCase(decryptedStr);
        } catch (Exception e) {
            return false;
        }
    }

    public static RpcAccessToken getGuestRpcAccessToken(String token){
        SysUser sysUser = SysUserUtil.getGuestUser();
        SsoUser ssoUser =SysUserUtil.convertToSsoUser(sysUser);
        ssoUser.setToken(token);
        ssoUser.setUserCatalog(RoleLevelEnum.guset.getValue());
        RpcAccessToken rpcAccessToken = new RpcAccessToken(ssoUser.getToken(), 60,ssoUser.getToken(), ssoUser);
        return rpcAccessToken;
    }


}
