package com.geoway.jckj.biz.util;

import com.geoway.jckj.base.support.spring.SpringUtils;
import com.geoway.jckj.biz.entity.BaseEntity;
import com.geoway.jckj.biz.entity.SaasEntity;
import com.geoway.jckj.biz.entity.SysTenant;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserService;
import com.geoway.jckj.biz.service.sys.SysTenantService;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author 连世忠
 * @ClassName SaasEntityUtil
 * @Description TODO
 * @date 2025/5/30 9:57
 * @Version 1.0
 */
public class SaasEntityUtil {
    public  static <T extends SaasEntity> void wrapper(List<T> entities){
        SysTenantService sysTenantService= SpringUtils.getBean(SysTenantService.class);
        List<SysTenant> tenants=sysTenantService.list();
        for(T entity:entities){
            if(entity==null){
                continue;
            }
            SysTenant tenant=tenants.stream().filter(f->f.getId().equals(entity.getTenantid())).findAny().orElse(null);
            if(tenant!=null){
                entity.setTenantkey(tenant.getName());
            }
        }
        BaseEntityUtil.wrapper(entities);
    }
}
