/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.dev.unity;

import cn.hutool.core.util.StrUtil;
import com.geoway.jckj.base.support.spring.SpringUtils;
import com.geoway.jckj.biz.config.UserSystemConfig;
import com.geoway.jckj.biz.enums.UserSysEnum;
import com.geoway.jckj.biz.service.dev.base.IUserSystem;
import com.geoway.jckj.biz.util.GuestUtil;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import com.geoway.sso.client.util.CookieUtils;
import com.geoway.sso.client.util.HttpServletUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Component
public class UnityUtil {
    private static UserSystemConfig userSystemConfig;
    private static String localUserType;
    private static String defaultUserType;

    public UnityUtil(UserSystemConfig userSystemConfig) {
        UnityUtil.userSystemConfig = userSystemConfig;
        defaultUserType = userSystemConfig.getUserSystem().get(0).getCode();
    }

    public static <T extends IUserSystem> T getService(Class<T> type) {
        String userType = UnityUtil.getCurrentUserType();
        return UnityUtil.getService(type, userType, true);
    }

    public static <T extends IUserSystem> T getDefaultService(Class<T> type) {
        return UnityUtil.getService(type, defaultUserType);
    }

    public static <T extends IUserSystem> T getLocalService(Class<T> type) {
        return UnityUtil.getService(type, localUserType);
    }

    public static <T extends IUserSystem> List<T> getServices(Class<T> type) {
        List userTypes = userSystemConfig.getUserSystem().stream().filter(f -> f.getEnable()).map(f -> f.getCode()).collect(Collectors.toList());
        List beans = SpringUtils.getBeansOfType(type);
        beans = beans.stream().filter(f -> userTypes.contains(f.getUserSystem())).collect(Collectors.toList());
        ArrayList<Object> result = new ArrayList<Object>();
        for (String userType : userTypes) {
            List typeBeans = beans.stream().filter(f -> f.getUserSystem().equals(userType)).collect(Collectors.toList());
            if (typeBeans.size() == 0) continue;
            if (typeBeans.size() == 1) {
                result.add(typeBeans.get(0));
                continue;
            }
            IUserSystem temp = (IUserSystem)typeBeans.get(0);
            for (IUserSystem service : typeBeans) {
                Class<?> aClass = service.getClass();
                Primary annotation = aClass.getAnnotation(Primary.class);
                if (annotation == null) continue;
                temp = service;
                break;
            }
            result.add(temp);
        }
        return result;
    }

    private static <T extends IUserSystem> T getService(Class<T> type, String userType, boolean returnLocalType) {
        T result = UnityUtil.getService(type, userType);
        if (result == null && returnLocalType) {
            return UnityUtil.getService(type, localUserType);
        }
        return result;
    }

    public static <T extends IUserSystem> T getService(Class<T> type, String userType) {
        List beans = SpringUtils.getBeansOfType(type);
        if ((beans = beans.stream().filter(f -> f.getUserSystem().equals(userType)).collect(Collectors.toList())).size() == 0) {
            return null;
        }
        IUserSystem result = (IUserSystem)beans.get(0);
        if (beans.size() == 1) {
            return (T)result;
        }
        for (IUserSystem service : beans) {
            Class<?> aClass = service.getClass();
            Primary annotation = aClass.getAnnotation(Primary.class);
            if (annotation == null) continue;
            result = service;
            break;
        }
        return (T)result;
    }

    private static String getCurrentUserType() {
        HttpServletRequest request = HttpServletUtil.getRequest();
        String parameterUserSys = request.getParameter("userSys");
        if (StrUtil.isNotBlank((CharSequence)parameterUserSys)) {
            return parameterUserSys;
        }
        String headerUserSys = request.getHeader("access_user_sys");
        if (StrUtil.isNotBlank((CharSequence)headerUserSys)) {
            return headerUserSys;
        }
        String cookieUserSys = CookieUtils.getCookie((HttpServletRequest)request, (String)"ns-design-userSys");
        if (StrUtil.isNotBlank((CharSequence)cookieUserSys)) {
            return cookieUserSys;
        }
        if (GuestUtil.validateGuestToken(CommonLoginUserUtil.getToken())) {
            return localUserType;
        }
        SsoUser ssoUser = CommonLoginUserUtil.getUser();
        String userSys = ssoUser != null ? ssoUser.getSource() : localUserType;
        return userSys;
    }

    static {
        localUserType = UserSysEnum.JCKJ.value;
        defaultUserType = "";
    }
}

