/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.dev.unity.impl;

import cn.hutool.captcha.AbstractCaptcha;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.biz.dto.CaptchaIMGDTO;
import com.geoway.jckj.biz.dto.CaptchaTextDTO;
import com.geoway.jckj.biz.service.dev.base.ILoginService;
import com.geoway.jckj.biz.service.dev.unity.IUnityLoginService;
import com.geoway.jckj.biz.service.dev.unity.impl.UnityBaseImpl;
import com.geoway.jckj.biz.service.login.ICaptchaService;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.HttpServletUtil;
import com.geoway.sso.client.util.SessionUtils;
import com.google.code.kaptcha.impl.DefaultKaptcha;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UnityLoginServiceImpl
extends UnityBaseImpl<ILoginService>
implements IUnityLoginService {
    private static final Logger log = LoggerFactory.getLogger(UnityLoginServiceImpl.class);
    @Autowired
    private ICaptchaService commonService;
    @Autowired
    private DefaultKaptcha defaultKaptcha;

    @Override
    public CaptchaTextDTO createCaptchaText(HttpServletRequest req) {
        String capText = this.defaultKaptcha.createText();
        UUID uid = UUID.randomUUID();
        String uuid = uid.toString();
        this.commonService.storeCaptcha(uuid, capText);
        CaptchaTextDTO captchaDTO = new CaptchaTextDTO();
        captchaDTO.setText(capText);
        captchaDTO.setUid(uuid);
        return captchaDTO;
    }

    @Override
    public CaptchaIMGDTO createCaptchaIMG(HttpServletRequest req, HttpServletResponse resp) {
        try {
            String w = req.getParameter("w");
            String h = req.getParameter("h");
            AbstractCaptcha captcha = this.commonService.createImageCaptcha(w, h);
            UUID uid = UUID.randomUUID();
            String uuid = uid.toString();
            this.commonService.storeCaptcha(uuid, captcha.getCode());
            CaptchaIMGDTO captchaIMGDTO = new CaptchaIMGDTO();
            captchaIMGDTO.setUid(uuid);
            captchaIMGDTO.setBase64(captcha.getImageBase64Data());
            return captchaIMGDTO;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public Result<SsoUser> loginByOne(String processId, String token, String authCode, HttpServletRequest req) {
        List loginServices = this.getServices();
        Result<SsoUser> result = null;
        for (ILoginService loginService : loginServices) {
            try {
                result = loginService.loginByOne(processId, token, authCode, req);
                if (result != null && result.getCode() == 3003) {
                    return result;
                }
                if (result != null && result.isSuccess()) {
                    ((SsoUser)result.getData()).setLoginTime(DateUtil.now());
                    ((SsoUser)result.getData()).setMachineName("Administrator");
                    ((SsoUser)result.getData()).setIp(HttpServletUtil.getRequestClientIp((HttpServletRequest)HttpServletUtil.getRequest()));
                    return result;
                }
                log.error(String.format("\u767b\u5f55\u65b9\u5f0f[%s]\u62a5\u9519\uff1a", loginService.getUserSystem()), (Object)(result == null ? "" : result.getMessage()));
                if (loginServices.indexOf(loginService) != loginServices.size() - 1) continue;
                throw new RuntimeException(result.getMessage());
            }
            catch (Exception exception) {
                log.error(String.format("\u767b\u5f55\u65b9\u5f0f[%s]\u62a5\u9519\uff1a", loginService.getUserSystem()), (Throwable)exception);
                throw new ServiceException("\u767b\u5165\u5931\u8d25\uff1a" + exception.getMessage(), (Throwable)exception);
            }
        }
        return result;
    }

    @Override
    public Result<SsoUser> loginByCa(String caUserCert, String caOauthName, HttpServletRequest req) {
        List loginServices = this.getServices();
        Result<SsoUser> result = null;
        for (ILoginService loginService : loginServices) {
            try {
                result = loginService.loginByCa(caUserCert, caOauthName, req);
                if (result != null && result.getCode() == 3003) {
                    return result;
                }
                if (result != null && result.isSuccess()) {
                    ((SsoUser)result.getData()).setLoginTime(DateUtil.now());
                    ((SsoUser)result.getData()).setMachineName("Administrator");
                    ((SsoUser)result.getData()).setIp(HttpServletUtil.getRequestClientIp((HttpServletRequest)HttpServletUtil.getRequest()));
                    return result;
                }
                log.error(String.format("\u767b\u5f55\u65b9\u5f0f[%s]\u62a5\u9519\uff1a", loginService.getUserSystem()), (Object)(result == null ? "" : result.getMessage()));
                if (loginServices.indexOf(loginService) != loginServices.size() - 1) continue;
                throw new RuntimeException(result.getMessage());
            }
            catch (Exception exception) {
                log.error(String.format("\u767b\u5f55\u65b9\u5f0f[%s]\u62a5\u9519\uff1a", loginService.getUserSystem()), (Throwable)exception);
                throw new ServiceException("\u767b\u5165\u5931\u8d25\uff1a" + exception.getMessage(), (Throwable)exception);
            }
        }
        return result;
    }

    @Override
    public Result<SsoUser> loginBySms(String tel, String uuid, String code, HttpServletRequest req) {
        List loginServices = this.getServices();
        Result<SsoUser> result = null;
        for (ILoginService loginService : loginServices) {
            try {
                result = loginService.loginBySms(tel, uuid, code, req);
                if (result != null && result.getCode() == 3003) {
                    return result;
                }
                if (result != null && result.isSuccess()) {
                    ((SsoUser)result.getData()).setLoginTime(DateUtil.now());
                    ((SsoUser)result.getData()).setMachineName("Administrator");
                    ((SsoUser)result.getData()).setIp(HttpServletUtil.getRequestClientIp((HttpServletRequest)HttpServletUtil.getRequest()));
                    return result;
                }
                log.error(String.format("\u767b\u5f55\u65b9\u5f0f[%s]\u62a5\u9519\uff1a", loginService.getUserSystem()), (Object)(result == null ? "" : result.getMessage()));
                if (loginServices.indexOf(loginService) != loginServices.size() - 1) continue;
                throw new RuntimeException(result.getMessage());
            }
            catch (Exception exception) {
                log.error(String.format("\u767b\u5f55\u65b9\u5f0f[%s]\u62a5\u9519\uff1a", loginService.getUserSystem()), (Throwable)exception);
                throw new ServiceException("\u767b\u5165\u5931\u8d25\uff1a" + exception.getMessage(), (Throwable)exception);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<SsoUser> login(String username, String password, String uuid, String code, HttpServletRequest req) {
        try {
            List loginServices = this.getServices();
            Result<SsoUser> result = null;
            for (ILoginService loginService : loginServices) {
                block11: {
                    try {
                        result = loginService.login(username, password, uuid, code, req);
                        if (result == null || result.getCode() != 3003) break block11;
                        Result<SsoUser> result2 = result;
                        return result2;
                    }
                    catch (Exception exception) {
                        log.error(String.format("\u767b\u5f55\u65b9\u5f0f[%s]\u62a5\u9519\uff1a", loginService.getUserSystem()), (Throwable)exception);
                        throw new ServiceException("\u767b\u5165\u5931\u8d25\uff1a" + exception.getMessage(), (Throwable)exception);
                    }
                }
                if (result != null && result.isSuccess()) {
                    ((SsoUser)result.getData()).setLoginTime(DateUtil.now());
                    ((SsoUser)result.getData()).setMachineName("Administrator");
                    ((SsoUser)result.getData()).setIp(HttpServletUtil.getRequestClientIp((HttpServletRequest)HttpServletUtil.getRequest()));
                    Result<SsoUser> result3 = result;
                    return result3;
                }
                log.error(String.format("\u767b\u5f55\u65b9\u5f0f[%s]\u62a5\u9519\uff1a", loginService.getUserSystem()), (Object)(result == null ? "" : result.getMessage()));
                if (loginServices.indexOf(loginService) != loginServices.size() - 1) continue;
                throw new RuntimeException(result.getMessage());
            }
            Iterator iterator = result;
            return iterator;
        }
        finally {
            if (StrUtil.isNotBlank((CharSequence)uuid)) {
                this.commonService.removeCaptcha(uuid);
            }
        }
    }

    @Override
    public Result<SsoUser> login(String username, String password) {
        Result<SsoUser> result = this.login(username, password, null, null, null);
        return result;
    }

    @Override
    public boolean loginOut(HttpServletRequest request, String access_token) {
        for (ILoginService loginService : this.getServices()) {
            loginService.loginOut(request, access_token);
        }
        SessionUtils.invalidate((HttpServletRequest)request, (String)access_token);
        return true;
    }
}

