package com.geoway.jckj.biz.service.dev.base.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.service.dev.base.IUserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * @author 连世忠
 * @ClassName AbstractUserServiceImpl
 * @Description TODO
 * @date 2024/3/13 15:13
 * @Version 1.0
 */
@Slf4j
public  abstract class AbstractUserServiceImpl implements IUserService {


    @Override
    public abstract SysUser query(String userId);
    @Override
    public abstract List<SysUser> query(List<String> userId);
    @Override
    public abstract List<SysUser> queryList(String filterParam);
    @Override
    public abstract IPage<SysUser> queryPage(String filterParam, int page, int size);

    @Override
    public IPage<SysUser> queryPage(String filterParam, int page, int size, boolean containAdmin) {
        return queryPage(filterParam,page,size);
    }



    @Override
    public void saveOrUp(SysUser user, MultipartFile file, boolean deletePhoto){
        throw new ServiceException("暂不支持修改和保存用户");
    }

    @Override
    public void batchSave(List<SysUser> users)  {
        for (SysUser user : users) {
            this.saveOrUp(user,null,false);
        }
    }

    /**
     * 直接修改用户密码，无需校验旧密码
     *
     * @param userId
     * @param password
     */
    @Override
    public  void changePassword(String userId, String password){
        throw new ServiceException("暂不支持修改用户密码");
    }

    @Override
    public String resetPassword(String userId) {
        throw new ServiceException("暂不支持密码重置");
    }

    @Override
    public boolean checkIsResetPassword(String userId) {
        return false;
    }

    @Override
    public void delete(String id){
        throw  new ServiceException("暂不支持删除用户");
    }

    @Override
    public void batchDelete(String ids)  {
        if (StrUtil.isBlank(ids)) {
            return;
        }
        List<String> idList = Arrays.asList(ids.split(","));
        for(String id:idList) {
            this.delete(id);
        }
    }

    @Override
    public void exportUsers(String filterParam, Boolean isTemplate, HttpServletResponse response) {
        throw  new ServiceException("暂不支持用户导出");
    }
    /**
     * 用户Excel批量导入
     *
     * @param userList        用户列表
     * @param isUpdateSupport 是否更新支持，如果已存在，则进行更新数据
     * @return 结果
     * @throws Exception
     */
    @Override
    public String importUsers(List<SysUser> userList, Boolean isUpdateSupport,String orgId) {
        throw  new ServiceException("暂不支持用户批量导入");
    }


    @Override
    public void changePassword(String userId, String oldPwd, String newPwd) {
        throw  new ServiceException("暂不支持修改用户密码");
    }

    @Override
    public Boolean changePassword(String phoneNum, String verifyCode, String verifyCodeUid, String password) throws Exception {
        throw  new ServiceException("暂不支持的操作");
    }




}
