package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.jckj.biz.entity.SysTenant;
import com.geoway.jckj.biz.entity.SysTenantMenu;
import com.geoway.jckj.biz.mapper.SysTenantMapper;
import com.geoway.jckj.biz.service.sys.SysRoleMenuService;
import com.geoway.jckj.biz.service.sys.SysRoleSystemService;
import com.geoway.jckj.biz.service.sys.SysTenantMenuService;
import com.geoway.jckj.biz.mapper.SysTenantMenuMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
* @author daidongdong
* @description 针对表【sys_tenant_menu(租户表)】的数据库操作Service实现
* @createDate 2025-01-09 17:52:35
*/
@Service
public class SysTenantMenuServiceImpl extends ServiceImpl<SysTenantMenuMapper, SysTenantMenu>
    implements SysTenantMenuService{

    @Autowired
    private SysTenantMapper sysTenantMapper;
    @Autowired
    private SysRoleMenuService sysRoleMenuService;
    @Autowired
    SysRoleSystemService sysRoleSystemService;
    @Override
    public void bindMenus(String tenantId, String systemId, List<SysTenantMenu> menus) {
        LambdaQueryWrapper<SysTenantMenu> menuWrapper = Wrappers.lambdaQuery();
        menuWrapper.eq(SysTenantMenu::getTenantid,tenantId);
        menuWrapper.eq(SysTenantMenu::getSystemid,systemId);
        SysTenant sysTenant=sysTenantMapper.selectById(tenantId);
        if(StrUtil.isNotBlank(sysTenant.getDefaultRoleId())){
            sysRoleMenuService.removeRelateMenus(sysTenant.getDefaultRoleId(),systemId);
            sysRoleMenuService.saveRoleMenus(sysTenant.getDefaultRoleId(),systemId,
                    menus.stream().map(f->f.getMenuid()).collect(Collectors.toList()));
        }
        this.remove(menuWrapper);
        this.saveBatch(menus);
    }
    @Override
    public List<SysTenantMenu> queryBindMenus(String tenantId, String systemId) {
        LambdaQueryWrapper<SysTenantMenu> menuWrapper = Wrappers.lambdaQuery();
        menuWrapper.eq(SysTenantMenu::getTenantid,tenantId);
        menuWrapper.eq(SysTenantMenu::getSystemid,systemId);
        List<SysTenantMenu> menus=this.list(menuWrapper);
        return menus;
    }
}




