package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.jckj.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.jckj.biz.entity.SysTheme;
import com.geoway.jckj.biz.mapper.SysThemeMapper;
import com.geoway.jckj.biz.service.sys.SysThemeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;

/**
 * 主题
 * @author: wujing
 * @Date: 2021/11/15
 */
@Service
public class SysThemeServiceImpl extends ServiceImpl<SysThemeMapper, SysTheme>
    implements SysThemeService {

    @Autowired
    private SysThemeMapper sysThemeMapper;

    @Override
    public void saveOrUp(SysTheme sysTheme) throws Exception {
        if(StrUtil.isBlank(sysTheme.getKey())){
            throw new Exception("关键字不能为空！");
        }else {
            LambdaQueryWrapper<SysTheme> wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysTheme::getKey, sysTheme.getKey());
            if(StrUtil.isNotBlank(sysTheme.getId())){
                wrapper.ne(SysTheme::getId, sysTheme.getId());
            }
            Integer one = this.count(wrapper);
            if(one>0){
                throw new Exception("关键字【"+ sysTheme.getKey()+"】已存在！");
            }
        }
        if(StrUtil.isBlank(sysTheme.getName())){
            throw new Exception("主题名称不能为空！");
        }


        boolean isExists = false;
        SysTheme oldTheme = null;
        if(StrUtil.isNotBlank(sysTheme.getId())) {
             oldTheme = this.getById(sysTheme.getId());
             isExists =  oldTheme != null;
        }
        if(!isExists){
            int iSort = sysThemeMapper.selectCount(null) + 1;
            sysTheme.setSort(iSort);
        }

        this.saveOrUpdate(sysTheme);
    }

    @Override
    public SysTheme findOne(String key) {
        LambdaQueryWrapper<SysTheme> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysTheme::getKey, key);
        wrapper.last("LIMIT 1");

        SysTheme one = this.getOne(wrapper);

        return one;
    }

    @Override
    public void delete(String ids) {
        String[] idArr = ids.split(",");
        this.removeByIds(Arrays.asList(idArr));
    }

    @Override
    public List<SysTheme> queryList(String filterParam) throws Exception {

        MyBatisQueryMapperUtils<SysTheme> qmu = new MyBatisQueryMapperUtils<>();
        QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysTheme.class);
        queryWrapper.orderByDesc("f_id");
        List<SysTheme>  themes = this.list(queryWrapper);

        return themes;
    }


}
