package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.sso.client.enums.RoleLevelEnum;
import com.geoway.jckj.biz.entity.*;
import com.geoway.jckj.biz.mapper.SysSystemMapper;
import com.geoway.jckj.biz.mapper.SysTenantMapper;
import com.geoway.jckj.biz.mapper.SysUserTenantMapper;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserService;
import com.geoway.jckj.biz.service.sys.SysUserTenantService;
import com.geoway.jckj.biz.service.sys.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author wangqiang
 * @description 针对表【sys_user_tenant(用户租户关联表)】的数据库操作Service实现
 * @createDate 2025-01-02 09:40:39
 */
@Service
@Transactional
public class SysUserTenantServiceImpl extends ServiceImpl<SysUserTenantMapper, SysUserTenant>
        implements SysUserTenantService {


    private final static String TENANT_ADMIN_ROLE_NAME="租户管理员角色";
    private final static String TENANT_ADMIN_ROLE_GROUP_NAME="租户管理员";
    @Autowired
    SysTenantSystemService sysTenantSystemService;
    @Autowired
    SysSystemMapper sysSystemMapper;
    @Autowired
    SysUserTenantMapper sysUserTenantMapper;
    @Autowired
    SysRoleService sysRoleService;
    @Autowired
    SysTenantMenuService sysTenantMenuService;
    @Autowired
    IUnityUserService unityUserService;
    @Autowired
    SysUserCatalogService sysUserCatalogService;
    @Autowired
    SysRoleSystemService  sysRoleSystemService;
    @Autowired
    SysTenantMapper sysTenantMapper;
    @Autowired
    SysRoleMenuService sysRoleMenuService;
    @Autowired
    private SysUserRoleService sysUserRoleService;


    @Override
    public void removeBindUsers(String tenantId, String userIds){

        if(StrUtil.isBlank(tenantId) || StrUtil.isBlank(userIds)){
            return;
        }
        List<String> userIdList = Arrays.asList(userIds.split(","));
        LambdaQueryWrapper<SysUserTenant> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysUserTenant::getTenantid,tenantId);
        queryWrapper.in(SysUserTenant::getUserid,userIdList);

        sysUserTenantMapper.delete(queryWrapper);
        userIdList.forEach(f->{
            removeDefaultRole(tenantId,f);
        });
         //设置用户级别为普通
        queryWrapper.clear();
        queryWrapper.in(SysUserTenant::getUserid,userIdList);

        List<SysUserTenant> userTenants = this.list(queryWrapper);
        List<String> mapUserIds = userTenants.stream().map( i -> i.getUserid()).collect(Collectors.toList());
        List<String> userValidIds = new ArrayList<>();
        for(String userId: userIdList){
            if(!mapUserIds.contains(userId)){
                userValidIds.add(userId);
            }
        }
        userValidIds.forEach(userValidId->{
            SysUserCatalog sysUserCatalog = new SysUserCatalog();
            //设置用户级别为普通
            sysUserCatalog.setUserCatalog(RoleLevelEnum.commonUser.getValue());
            sysUserCatalog.setUserid(userValidId);
            sysUserCatalogService.saveOrUp(sysUserCatalog);
        });


    }

    @Override
    public List<SysUser> queryBindUsers(String tenantId) {
        List<SysUserTenant> userTenants=getBindUsers(tenantId);
        return unityUserService.query(userTenants.stream().map(f->f.getUserid()).collect(Collectors.toList()));
    }

    private List<SysUserTenant> getBindUsers(String tenantId){
        LambdaQueryWrapper<SysUserTenant> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysUserTenant::getTenantid,tenantId);
        List<SysUserTenant> userTenants = this.list(queryWrapper);
        return userTenants;
    }

    @Override
    public IPage<SysUser> queryPageUsers(String filterParam, String tenantId, int page, int size) {
        if(StrUtil.isBlank(filterParam)){
            filterParam="";
        }
        if(StrUtil.isNotBlank(filterParam)){
            filterParam=filterParam+";";
        }
        List<SysUserTenant> userTenants=getBindUsers(tenantId);
        if(userTenants.size()>0){
             filterParam+="Q_id_N_NOTIN="+StrUtil.join(",", userTenants.stream().map(f->f.getUserid()).collect(Collectors.toList()))+";";
        }
        return unityUserService.queryPage(filterParam,page,size,false);
    }


    @Override
    public void bindUsers(String userIds, String tenantId, Integer isAdmin) {
        List<SysUserTenant> toAdd = new ArrayList<>();
        for (String userId : userIds.split(",")) {
            int exist = this.count(Wrappers.lambdaQuery(SysUserTenant.class).eq(SysUserTenant::getUserid, userId)
                    .eq(SysUserTenant::getTenantid, tenantId));
            if (exist > 0) {
                throw new ServiceException("当前用户已存在！");
            }

            if (isAdmin == 1) {
                SysUserCatalog sysUserCatalog=new SysUserCatalog();
                // 把租户管理员的userCatalog改为2
                sysUserCatalog.setUserCatalog(RoleLevelEnum.tenantAdmin.getValue());
                sysUserCatalog.setUserid(userId);
                sysUserCatalogService.saveOrUp(sysUserCatalog);
                //授权租户管理员默认角色
                bindDefaultRole(tenantId,userId);
            }

            toAdd.add(SysUserTenant.builder().tenantid(tenantId).userid(userId).isAdmin(isAdmin).build());
        }

        this.saveBatch(toAdd);
    }

    /**
     * 添加租户管理员默认角色
     * @param tenantId
     * @param userId
     */
    private void bindDefaultRole(String tenantId,String userId){
        try {
            SysTenant sysTenant=sysTenantMapper.selectById(tenantId);
            if (StrUtil.isBlank(sysTenant.getDefaultRoleId())) {
                //创建默认角色分组
                SysRole groupRole = new SysRole();
                groupRole.setTenantid(tenantId);
                groupRole.setLevel(1);
                groupRole.setName(TENANT_ADMIN_ROLE_GROUP_NAME);
                groupRole.setType(0);
                groupRole.setKey(TENANT_ADMIN_ROLE_GROUP_NAME);
                sysRoleService.saveOrUp(groupRole);
                //创建默认角色
                SysRole sysRole=new SysRole();
                sysRole.setTenantid(tenantId);
                sysRole.setLevel(2);
                sysRole.setName(TENANT_ADMIN_ROLE_NAME);
                sysRole.setType(1);
                sysRole.setPid(groupRole.getId());
                sysRole.setKey(TENANT_ADMIN_ROLE_NAME);
                sysRoleService.saveOrUp(sysRole);
                //绑定系统
                List<SysSystem> sysSystems=sysTenantSystemService.queryBindSystems(tenantId);
                sysRoleSystemService.saveRoleSystems(sysRole.getId(),sysSystems.stream().map(f->f.getId()).collect(Collectors.toList()),true);
                //绑定菜单
                for(SysSystem sysSystem:sysSystems) {
                    List<SysTenantMenu> sysTenantMenus=sysTenantMenuService.queryBindMenus(tenantId,sysSystem.getId());
                    sysRoleMenuService.saveRoleMenus(sysRole.getId(),sysSystem.getId(),
                            sysTenantMenus.stream().map(f->f.getMenuid()).collect(Collectors.toList()));
                }
                sysTenant.setDefaultRoleId(sysRole.getId());
                sysTenantMapper.updateById(sysTenant);
            }

            //授权租户管理员租户管理员的默认角色
            sysUserRoleService.bindUsers(sysTenant.getDefaultRoleId(), Collections.singletonList(userId));

        }catch (Exception e){
            throw new ServiceException(e.getMessage(),e);
        }
    }

    /**
     * 移除租户管理员默认角色
     * @param tenantId
     * @param userId
     */
    private void removeDefaultRole(String tenantId,String userId){
        SysTenant sysTenant=sysTenantMapper.selectById(tenantId);
        if (StrUtil.isBlank(sysTenant.getDefaultRoleId())){
            return;
        }
        sysUserRoleService.removeBindUsers(sysTenant.getDefaultRoleId(),Collections.singletonList(userId));
    }
}




