/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.biz.entity.SysSystem;
import com.geoway.jckj.biz.entity.SysTenant;
import com.geoway.jckj.biz.entity.SysTenantMenu;
import com.geoway.jckj.biz.entity.SysTenantSystem;
import com.geoway.jckj.biz.mapper.SysSystemMapper;
import com.geoway.jckj.biz.mapper.SysTenantMapper;
import com.geoway.jckj.biz.mapper.SysTenantSystemMapper;
import com.geoway.jckj.biz.service.sys.SysRoleMenuService;
import com.geoway.jckj.biz.service.sys.SysRoleSystemService;
import com.geoway.jckj.biz.service.sys.SysTenantMenuService;
import com.geoway.jckj.biz.service.sys.SysTenantSpaceService;
import com.geoway.jckj.biz.service.sys.SysTenantSystemService;
import com.geoway.jckj.biz.util.SaasEntityUtil;
import com.github.yulichang.toolkit.MPJWrappers;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysTenantSystemServiceImpl
extends ServiceImpl<SysTenantSystemMapper, SysTenantSystem>
implements SysTenantSystemService {
    @Autowired
    SysSystemMapper sysSystemMapper;
    @Autowired
    SysTenantMenuService sysTenantMenuService;
    @Autowired
    SysTenantSpaceService sysTenantSpaceService;
    @Autowired
    SysRoleSystemService sysRoleSystemService;
    @Autowired
    SysTenantMapper sysTenantMapper;
    @Autowired
    SysRoleMenuService sysRoleMenuService;

    @Override
    public void bindSystems(String tenantId, String systemIds) {
        SysTenant sysTenant;
        this.removeBindSystems(tenantId, systemIds);
        String[] systemIdArr = systemIds.split(",");
        SysTenantSystem sysTenantSystem = null;
        ArrayList<SysTenantSystem> sysTenantSystems = new ArrayList<SysTenantSystem>();
        List sysSystems = this.sysSystemMapper.selectBatchIds(Arrays.asList(systemIdArr));
        for (SysSystem sysSystem : sysSystems) {
            sysTenantSystem = new SysTenantSystem();
            BeanUtil.copyProperties((Object)sysSystem, (Object)sysTenantSystem, (String[])new String[]{"id"});
            sysTenantSystem.setSystemid(sysSystem.getId());
            sysTenantSystem.setTenantid(tenantId);
            sysTenantSystems.add(sysTenantSystem);
        }
        if (sysTenantSystems.size() > 0) {
            this.saveBatch(sysTenantSystems);
        }
        if (StrUtil.isNotBlank((CharSequence)(sysTenant = (SysTenant)this.sysTenantMapper.selectById((Serializable)((Object)tenantId))).getDefaultRoleId())) {
            this.sysRoleSystemService.saveRoleSystems(sysTenant.getDefaultRoleId(), Arrays.asList(systemIdArr), false);
        }
    }

    @Override
    public void removeBindSystems(String tenantId, String systemIds) {
        if (StrUtil.isBlank((CharSequence)tenantId) || StrUtil.isBlank((CharSequence)systemIds)) {
            return;
        }
        List<String> systemIdList = Arrays.asList(systemIds.split(","));
        LambdaQueryWrapper clearWrapper = Wrappers.lambdaQuery();
        clearWrapper.eq(SysTenantSystem::getTenantid, (Object)tenantId);
        clearWrapper.in(SysTenantSystem::getSystemid, systemIdList);
        this.remove((Wrapper)clearWrapper);
        LambdaQueryWrapper menuWrapper = Wrappers.lambdaQuery();
        menuWrapper.eq(SysTenantMenu::getTenantid, (Object)tenantId);
        menuWrapper.in(SysTenantMenu::getSystemid, systemIdList);
        this.sysTenantMenuService.remove((Wrapper)menuWrapper);
        SysTenant sysTenant = (SysTenant)this.sysTenantMapper.selectById((Serializable)((Object)tenantId));
        if (StrUtil.isNotBlank((CharSequence)sysTenant.getDefaultRoleId())) {
            this.sysRoleSystemService.removeRoleSystem(sysTenant.getDefaultRoleId(), systemIdList);
        }
    }

    @Override
    public List<SysSystem> queryBindSystems(String tenantId) {
        MPJLambdaWrapper queryWrapper = MPJWrappers.lambdaJoin();
        queryWrapper.eq(SysTenantSystem::getTenantid, (Object)tenantId);
        List sysTenantSystems = this.list((Wrapper)queryWrapper);
        if (sysTenantSystems.size() == 0) {
            return new ArrayList<SysSystem>();
        }
        ArrayList<SysSystem> systems = new ArrayList<SysSystem>();
        for (SysTenantSystem sysTenantSystem : sysTenantSystems) {
            SysSystem sysSystem = (SysSystem)this.sysSystemMapper.selectById((Serializable)((Object)sysTenantSystem.getSystemid()));
            if (sysSystem == null) continue;
            String dispalyName = sysSystem.getName();
            if (!sysSystem.getName().equals(sysTenantSystem.getName())) {
                dispalyName = String.format("%s(%s)", sysTenantSystem.getName(), sysSystem.getName());
            }
            BeanUtil.copyProperties((Object)sysTenantSystem, (Object)sysSystem, (String[])new String[]{"id", "tenantid"});
            systems.add(sysSystem);
            sysSystem.setDisplayName(dispalyName);
        }
        SaasEntityUtil.wrapper(systems);
        systems.forEach(f -> f.setSpaceStatus(this.sysTenantSpaceService.checkSpaceStatus(tenantId, f.getId()).getValue()));
        return systems;
    }

    @Override
    public void saveSystem(String tenantId, SysSystem sysSystem) {
        MPJLambdaWrapper queryWrapper = MPJWrappers.lambdaJoin();
        queryWrapper.eq(SysTenantSystem::getTenantid, (Object)tenantId);
        queryWrapper.eq(SysTenantSystem::getSystemid, (Object)sysSystem.getId());
        SysTenantSystem sysTenantSystems = (SysTenantSystem)this.getOne((Wrapper)queryWrapper, true);
        if (sysTenantSystems == null) {
            throw new ServiceException("\u7cfb\u7edf:" + sysSystem.getName() + ",\u6ca1\u6709\u6388\u6743\u7ed9\u8be5\u79df\u6237\uff0c\u65e0\u6cd5\u8fdb\u884c\u7f16\u8f91");
        }
        BeanUtil.copyProperties((Object)sysSystem, (Object)sysTenantSystems, (String[])new String[]{"id", "tenantid"});
        this.saveOrUpdate(sysTenantSystems);
    }
}

