/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.base.support.spring.SpringUtils;
import com.geoway.jckj.biz.entity.SysRole;
import com.geoway.jckj.biz.entity.SysUserRole;
import com.geoway.jckj.biz.mapper.SysUserRoleMapper;
import com.geoway.jckj.biz.service.sys.SysRoleService;
import com.geoway.jckj.biz.service.sys.SysUserRoleService;
import com.geoway.sso.client.annotation.OpLog;
import com.geoway.sso.client.enums.OpTypeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class SysUserRoleServiceImpl
extends ServiceImpl<SysUserRoleMapper, SysUserRole>
implements SysUserRoleService {
    @Override
    @OpLog(name="\u4fee\u6539\u7528\u6237\u6240\u5c5e\u89d2\u8272", opType=OpTypeEnum.update)
    public void updateUserRole(String userId, List<String> roleIds) {
        try {
            SysRoleService sysRoleService = (SysRoleService)SpringUtils.getBean(SysRoleService.class);
            List<SysRole> sysRoles = sysRoleService.queryList("");
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysUserRole::getUserid, (Object)userId);
            wrapper.in(SysUserRole::getRoleid, (Collection)sysRoles.stream().map(f -> f.getId()).collect(Collectors.toList()));
            this.remove((Wrapper)wrapper);
            if (roleIds == null) {
                return;
            }
            ArrayList<SysUserRole> userRoles = new ArrayList<SysUserRole>();
            for (String roleId : roleIds) {
                SysUserRole userRole = new SysUserRole();
                userRole.setUserid(userId);
                userRole.setRoleid(roleId);
                userRoles.add(userRole);
            }
            if (userRoles.size() > 0) {
                this.saveBatch(userRoles);
            }
        }
        catch (Exception exception) {
            throw new ServiceException((Throwable)exception);
        }
    }

    @Override
    public void updateRoleUsers(String roleId, List<String> userIds) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysUserRole::getRoleid, (Object)roleId);
        this.remove((Wrapper)wrapper);
        ArrayList<SysUserRole> userRoles = new ArrayList<SysUserRole>();
        for (String userId : userIds) {
            SysUserRole userRole = new SysUserRole();
            userRole.setUserid(userId);
            userRole.setRoleid(roleId);
            userRoles.add(userRole);
        }
        if (userRoles.size() > 0) {
            this.saveBatch(userRoles);
        }
    }

    @Override
    public List<String> queryRoleUserIds(String roleId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysUserRole::getRoleid, (Object)roleId);
        List<String> userIds = this.list((Wrapper)wrapper).stream().map(i -> i.getUserid()).collect(Collectors.toList());
        return userIds;
    }

    @Override
    public void bindUsers(String roleId, List<String> userIds) {
        if (StrUtil.isBlank((CharSequence)roleId) || userIds == null || userIds.size() == 0) {
            return;
        }
        this.removeBindUsers(roleId, userIds);
        ArrayList<SysUserRole> userRoles = new ArrayList<SysUserRole>();
        for (String userId : userIds) {
            SysUserRole userRole = new SysUserRole();
            userRole.setUserid(userId);
            userRole.setRoleid(roleId);
            userRoles.add(userRole);
        }
        this.saveBatch(userRoles);
    }

    @Override
    public void removeBindUsers(String roleId, List<String> userIds) {
        if (StrUtil.isBlank((CharSequence)roleId) || userIds == null || userIds.size() == 0) {
            return;
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysUserRole::getRoleid, (Object)roleId);
        queryWrapper.in(SysUserRole::getUserid, userIds);
        this.remove((Wrapper)queryWrapper);
    }
}

