package com.geoway.jckj.biz.config;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * @author ALMJ
 * @desc 单点登录相关配置
 * @date 2022/10/17 17:46
 */
@Component
@Getter
@Setter
@ToString
public class SsoConfig {
    /**
     * 单点登录是否开启
     */
    @Value("${sso.enable:false}")
    private boolean enable;
    /**
     * 单点登录session 缓存方式
     */
    @Value("${sso.session.manager:redis}")
    private String sessionManager;
    /**
     * 登录后无操作过期时间
     */
    @Value("${sso.timeout:7200}")
    private int timeout;

    /**
     * 单点登录服务地址
     */
    @Value("${sso.server.url:}")
    private String serverUrl;


    /**
     * 登陆页模板名称,如login2.html 则 /login2，userLogin
     */
    @Value("${sso.setting.login-path:null}")
    private String loginPath;

    /**
     * 登录页面类型, cas:默认内置的统一登录页面; custom: 前端自定义登录页面
     */
    @Value("${sso.setting.login-page:custom}")
    private String loginPage;

    /**
     * 登录二维码过期时间,单位分钟(默认300秒)
     */
    @Value("${sso.setting.qr-timeout:300}")
    private int qrTimeout;

    @Value("${sso.setting.singeUser:false}")
    private Boolean singeUser;

    @Value("${sso.app.loginApi:}")
    private String appLoginApi;

    @Value("${sso.app.id:}")
    private String appId;

    @Value("${sso.app.secret:}")
    private String appSecret;

    @Value("${sso.tenant.user-range:3}")
    private Integer tenantUserRange;
}
