package com.geoway.jckj.biz.dto.uis;

import com.geoway.jckj.biz.entity.SysOrganization;
import com.geoway.jckj.biz.entity.SysRegion;
import com.geoway.jckj.biz.entity.SysRole;
import com.geoway.jckj.biz.entity.SysUser;
import lombok.Data;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author 阿力
 * @desc UIS用户实体与映射处理
 */
@Data
public class SimpleUserDTO {

    private static final long serialVersionUID = 1L;
    /**
     * 用户ID
     */
    private String id;
    /**
     * 用户名
     */
    private String username;
    /**
     * 与userName一样，为了兼容
     */
    private String name;
    /**
     * 用户密码
     */
    private String password;
    /**
     * 性别
     */
    private Integer sex;
    /**
     * 邮编
     */
    private String email;
    /**
     * 电话
     */
    private String telphone;

    private String phone;

    /**
     * 与telphone一样，为了兼容
     */
    private String phonework;

    /**
     * 用户中文名
     */
    private String rname;

    /**
     * 用户状态
     */
    private Integer state;

    /**
     * 注册应用id
     */
    private String registerAppId;

    /**
     * 注册时间
     */
    private Date registertime;
    /**
     * 所系结构ID
     */
    private String orgIds;
    /**
     * 所系行政区代码
     */
    private String regioncode;

    /**
     * 应用信息
     */
    private List<ApplicationInfo> applications;
    /**
     * 用户所在机构
     */
    private List<OrganizationDTO> organizations;

    /**
     * 用户所属行政区
     */
    private List<RegionDTO> regions;

    /**
     * 用户角色
     */
    private List<SimpleRoleDTO> roles;

    /**
     *
     */
    private String imgId;

    /**
     *
     */
    private Integer userCatalog;
    /**
     * 用户简要信息映射
     *
     * @param user
     * @return
     */
    public SimpleUserDTO sysUser2simpleUser(SysUser user) {
        this.setId(user.getId());
        this.setName(user.getName());
        this.setUsername(user.getName());
        this.setRname(user.getAname());
        this.setTelphone(user.getTel());
        this.setPhone(user.getTel());
        this.setPhonework(user.getWorktel());
        this.setEmail(user.getEmail());
        this.setSex(Integer.valueOf(user.getSex()));
        this.setRegistertime(user.getCreatetime());
        this.setState(Integer.valueOf(user.getStatus()));
        return this;
    }

    /**
     * 集成框架用户实体转UIS用户实体
     *
     * @param user       用户对象
     * @param orgList    机构对象
     * @param roleList   角色对象
     * @param regionList 行政区对象
     * @return
     */
    public SimpleUserDTO sysUser2simpleUser(SysUser user, List<SysOrganization> orgList, List<SysRole> roleList, List<SysRegion> regionList) {
        this.setId(user.getId());
        this.setName(user.getName());
        this.setUsername(user.getName());
        this.setRname(user.getAname());
        this.setTelphone(user.getTel());
        this.setPhone(user.getTel());
        this.setPhonework(user.getWorktel());
        this.setEmail(user.getEmail());
        this.setSex(Integer.valueOf(user.getSex()));
        this.setRegistertime(user.getCreatetime());
        this.setState(Integer.valueOf(user.getStatus()));
        this.setImgId(user.getImgid());
        this.setUserCatalog(user.getCatalog());

        this.setOrgIds(org2Orgids(orgList));
        this.setOrganizations(org2UisOrg(orgList));
        this.setRegioncode(regionList2Code(regionList));
        this.setRoles(role2UisRole(roleList));
        this.setRegions(region2UisRegion(regionList));
        return this;
    }

    /**
     * 集成框架机构转UIS机构实体
     *
     * @param orgs
     * @return
     */

    public List<OrganizationDTO> org2UisOrg(List<SysOrganization> orgs) {
        List<OrganizationDTO> organizationDTOS = new ArrayList<>();
        Iterator<SysOrganization> iterator = orgs.iterator();
        while (iterator.hasNext()) {
            SysOrganization org = iterator.next();
            OrganizationDTO uisOrgItem = new OrganizationDTO();
            uisOrgItem.setId(org.getId());
            uisOrgItem.setName(org.getName());
            uisOrgItem.setText(org.getAname());
            uisOrgItem.setCode(org.getCode());
            uisOrgItem.setLevel(org.getLevel());
            uisOrgItem.setPid(org.getPid());
            uisOrgItem.setDescription(org.getBz());
            organizationDTOS.add(uisOrgItem);
        }
        for (int index = 0; index < orgs.size(); index++) {
            SysOrganization org = orgs.get(index);
            OrganizationDTO organizationDTO = organizationDTOS.get(index);
            List<SysOrganization> children = org.getChildren();
            if (children != null && children.size() > 0) {
                organizationDTO.setChildren(org2UisOrg(org.getChildren()));
            }
        }
        return organizationDTOS;

    }

    /**
     * 获取机构中的辖区代码赋给当前用户
     *
     * @param orgs
     * @return
     */
    private String org2RegionCode(List<SysOrganization> orgs) {
        String regionCode = "";
        if (orgs != null && orgs.size() > 0) {
            regionCode = orgs.get(0).getCode();
        }
        return regionCode;
    }


    /**
     * 集成框架角色转UIS角色实体
     *
     * @param roles
     * @return
     */
    public List<SimpleRoleDTO> role2UisRole(List<SysRole> roles) {
        List<SimpleRoleDTO> roleDTOS = new ArrayList<>();
        for (SysRole sysRole : roles) {
            SimpleRoleDTO uisRoleItem = new SimpleRoleDTO();
            uisRoleItem.setId(sysRole.getId());
            uisRoleItem.setRolename(sysRole.getName());
            uisRoleItem.setLevel(sysRole.getLevel());
            uisRoleItem.setCreateTime(sysRole.getCreateTime());
            roleDTOS.add(uisRoleItem);
        }
        return roleDTOS;
    }

    /**
     * 集成框架行政区转UIS行政区实体
     *
     * @param regions
     * @return
     */
    public List<RegionDTO> region2UisRegion(List<SysRegion> regions) {
        List<RegionDTO> regionDTOS = new ArrayList<>();
        //regions = filterRegionList(regions);
        Iterator<SysRegion> iterator = regions.iterator();
        while (iterator.hasNext()) {
            RegionDTO uisRegionItem = new RegionDTO();
            SysRegion sysRegion = iterator.next();
            uisRegionItem.setId(sysRegion.getId());
            uisRegionItem.setCode(sysRegion.getCode());
            uisRegionItem.setName(sysRegion.getName());
            uisRegionItem.setLevel(sysRegion.getLevel());
            uisRegionItem.set_parentId(sysRegion.getPcode());
            uisRegionItem.setPid(sysRegion.getPcode());
            regionDTOS.add(uisRegionItem);
        }

        for (int index = 0; index < regions.size(); index++) {
            SysRegion sysRegion = regions.get(index);
            RegionDTO regionDTO = regionDTOS.get(index);
            List<SysRegion> children = sysRegion.getChildren();
            if (children != null && children.size() > 0) {
                regionDTO.setChildren(region2UisRegion(sysRegion.getChildren()));
            }
        }
        return regionDTOS;
    }

    /**
     * 拼接机构id
     *
     * @param orgs
     * @return
     */
    private String org2Orgids(List<SysOrganization> orgs) {
        return orgs.stream()
                .filter(org -> !org.getId().isEmpty())
                .map(org -> org.getId())
                .collect(Collectors.joining(","));
    }

    /**
     * 取最下面的行政区
     *
     * @param regions
     * @return
     */
    private String regionList2Code(List<SysRegion> regions) {
        String regionCode = "";
        int level = 1;
        Iterator<SysRegion> iterator = regions.iterator();
        while (iterator.hasNext()) {
            SysRegion sysRegion = iterator.next();
            if (sysRegion.getLevel() >= level) {
                regionCode = sysRegion.getCode();
            }
            level = sysRegion.getLevel();
        }
        return regionCode;
    }


    private List<SysRegion> filterRegionList(List<SysRegion> regions) {
        List<SysRegion> filterRegions = new ArrayList<>();
        int level = 1;
        Iterator<SysRegion> iterator = regions.iterator();
        while (iterator.hasNext()) {
            filterRegions = new ArrayList<>();
            SysRegion sysRegion = iterator.next();
            if (sysRegion.getLevel() >= level) {
                filterRegions.add(sysRegion);
            }
            level = sysRegion.getLevel();
        }
        return filterRegions;
    }
}
