package com.geoway.jckj.biz.service.login.impl;

import cn.hutool.captcha.AbstractCaptcha;
import cn.hutool.captcha.CaptchaUtil;
import cn.hutool.captcha.LineCaptcha;
import cn.hutool.core.util.StrUtil;
import com.geoway.jckj.base.support.RedisUtil;
import com.geoway.jckj.biz.service.login.ICaptchaService;
import com.geoway.sso.server.config.PropertyConfig;
import com.geoway.sso.server.constant.AppConstant;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.util.Random;
import java.util.concurrent.TimeUnit;

@Service("commonService")
public class CaptchaServiceImpl implements ICaptchaService {
    @Value("${app.setting.captcha.length:4}")
    private int codeCount;

    @Value("${app.setting.captcha.width:96}")
    private int width;

    @Value("${app.setting.captcha.height:32}")
    private int height;

    char[] codeSequence = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    PropertyConfig propertyConfig;


    @Override
    public AbstractCaptcha createImageCaptcha(String imageWidth, String imageHeight) {
        if (StringUtils.isNotBlank(imageWidth)) {
            this.width = Integer.parseInt(imageWidth);
        }
        if (StringUtils.isNotBlank(imageHeight)) {
            this.height = Integer.parseInt(imageHeight);
        }
        LineCaptcha lineCaptcha = CaptchaUtil.createLineCaptcha(width, height, 4, 20);
        return lineCaptcha;
    }

    @Override
    public void storeCaptcha(String sessionId, String captchaText) {
        String key = sessionId + AppConstant.CAPTCHA_SESSION_TEXT;
        redisUtil.set(key, captchaText, 3, TimeUnit.MINUTES);
    }

    @Override
    public String queryCaptcha(String sessionId) {
        String key = sessionId + AppConstant.CAPTCHA_SESSION_TEXT;
        return (String) redisUtil.get(key);
    }

    @Override
    public void removeCaptcha(String sessionId) {
        String key = sessionId + AppConstant.CAPTCHA_SESSION_TEXT;
        redisUtil.del(key);

    }

    @Override
    public boolean validateCaptcha(String code, String storeCode) {
        Boolean isDev = propertyConfig.getRunMode().indexOf("dev") > -1;
        if (StrUtil.isBlank(storeCode) || StrUtil.isBlank(code)) {
            return false;
        }
        if (isDev) {
            if (!code.equalsIgnoreCase(storeCode) && !code.equalsIgnoreCase("4567")) {
                return false;
            }
        } else {
            if (!code.equalsIgnoreCase(storeCode)) {
                return false;
            }
        }
        return true;
    }
}
