package com.geoway.jckj.biz.service.sys;

import com.baomidou.mybatisplus.extension.service.IService;
import com.geoway.jckj.biz.entity.SysUserApplication;

/**
* @author daidongdong
* @description 针对表【sys_user_application(应用关联的用户，只针对二级管理员)】的数据库操作Service
* @createDate 2024-10-15 17:22:57
*/
public interface SysUserApplicationService extends IService<SysUserApplication> {

    /**
     * 更新用户和应用权限
     * @param userId
     * @param appId
     * @param appType
     * @param nodeType
     */
    void updateUserApplication(String userId,String appId,int appType,int nodeType);


    /**
     * 删除已存在的应用权限
     * @param userId
     * @param appId
     * @param appType
     */
    void deleteExistApplication(String userId,String appId, int appType);

    /**
     * 删除分组（不存在子节点）
     * @param userId
     * @param groupId
     * @param appType
     * @return
     */
    void deleteGroupIsNoChild(String userId,String groupId, int appType);

}
